<?php

/**
 * ReduxFramework Sample Config File
 * For full documentation, please visit: http://docs.reduxframework.com/
 */

if (!class_exists('Redux')) {
    return;
}

/* This is your option name where all the Redux data is stored.*/
$opt_name = "poket_opt";

/**
 * ---> SET ARGUMENTS
 * All the possible arguments for Redux.
 * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
 *
 */

$theme = wp_get_theme(); /* For use with some settings. Not necessary.*/
$args = array(
    /* TYPICAL -> Change these values as you need/desire*/
    'opt_name' => $opt_name,
    /* This is where your data is stored in the database and also becomes your global variable name.*/
    'display_name' => $theme->get('Name'),
    /* Name that appears at the top of your panel*/
    'display_version' => $theme->get('Version'),
    /* Version that appears at the top of your panel*/
    'menu_type' => 'submenu',
    /*Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)*/
    'allow_sub_menu' => true,
    /* Show the sections below the admin menu item or not*/
    'menu_title' => esc_html__('poket Theme Options', 'poket'),
    'page_title' => esc_html__('poket Theme Options', 'poket'),
    /* You will need to generate a Google API key to use this feature.*/
    /* Please visit: https://developers.google.com/fonts/docs/developer_api#Aut*/
    'google_api_key' => '',
    /* Set it you want google fonts to update weekly. A google_api_key value is required.*/
    'google_update_weekly' => false,
    /* Must be defined to add google fonts to the typography module*/
    'async_typography' => true,
    /* Use a asynchronous font on the front end or font string*/
    /*'disable_google_fonts_link' => true, */                   /* Disable this in case you want to create your own google fonts loader*/
    'admin_bar' => true,
    /* Show the panel pages on the admin bar*/
    'admin_bar_icon' => 'dashicons-portfolio',
    /* Choose an icon for the admin bar menu*/
    'admin_bar_priority' => 50,
    /* Choose an priority for the admin bar menu*/
    'global_variable' => '',
    /* Set a different name for your global variable other than the opt_name*/
    'dev_mode' => false,
    /* Show the time the page took to load, etc*/
    'update_notice' => false,
    /* If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo*/
    'customizer' => false,
    /* Enable basic customizer support*/
    /*'open_expanded'     => true, */                   /* Allow you to start the panel in an expanded way initially.*/
    /*'disable_save_warn' => true,  */                  /* Disable the save warning when a user changes a field*/
    /* OPTIONAL -> Give you extra features*/
    'page_priority' => null,
    /* Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.*/
    'page_parent' => 'themes.php',
    /* For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters*/
    'page_permissions' => 'manage_options',
    /* Permissions needed to access the options panel.*/
    'menu_icon' => '',
    /* Specify a custom URL to an icon*/
    'last_tab' => '',
    /* Force your panel to always open to a specific tab (by id)*/
    'page_icon' => 'icon-themes',
    /* Icon displayed in the admin panel next to your menu_title*/
    'page_slug' => '',
    /* Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided*/
    'save_defaults' => true,
    /* On load save the defaults to DB before user clicks save or not*/
    'default_show' => false,
    /* If true, shows the default value next to each field that is not the default value.*/
    'default_mark' => '',
    /* What to print by the field's title if the value shown is default. Suggested: * */
    'show_import_export' => true,
    /* Shows the Import/Export panel when not used as a field.*/
    /* CAREFUL -> These options are for advanced use only*/
    'transient_time' => 60 * MINUTE_IN_SECONDS,
    'output' => true,
    /* Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output*/
    'output_tag' => true,
    /* Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head*/
    /* 'footer_credit'     => '',                   /* Disable the footer credit of Redux. Please leave if you can help it.*/
    /* FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.*/
    'database' => '',
    /* possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!*/
    'use_cdn' => true,
    /* If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.*/
    /* HINTS */
    'hints' => array(
        'icon' => 'el el-question-sign',
        'icon_position' => 'right',
        'icon_color' => 'lightgray',
        'icon_size' => 'normal',
        'tip_style' => array(
            'color' => 'red',
            'shadow' => true,
            'rounded' => false,
            'style' => '',
        ),
        'tip_position' => array(
            'my' => 'top left',
            'at' => 'bottom right',
        ),
        'tip_effect' => array(
            'show' => array(
                'effect' => 'slide',
                'duration' => '500',
                'event' => 'mouseover',
            ),
            'hide' => array(
                'effect' => 'slide',
                'duration' => '500',
                'event' => 'click mouseleave',
            ),
        ),
    )
);

Redux::setArgs($opt_name, $args);

/*
 * ---> END ARGUMENTS
*/
/*
 *
 * ---> START SECTIONS
 *
*/

/*

        As of Redux 3.5+, there is an extensive API. This API can be used in a mix/match mode allowing for


*/

/* -> START Basic Fields*/
Redux::setSection($opt_name, array(
    'title' => esc_html__('Genarel Option', 'poket'),
    'id' => 'wellgoption',
    'icon' => 'el-icon-cog',
    'fields' => array(
        array(
            'id' => 'dfgfdgdf',
            'type' => 'info',
            'title' => esc_html__('Welcome Our Theme Option', 'poket'),
        ),
    )
));

Redux::setSection($opt_name, array(
    'title' => esc_html__('Global Color Option', 'poket'),
    'id' => 'main_logo_id',
    'customizer_width' => '400px',
    'icon' => 'el-icon-cog',
    'fields' => array(
        array(
            'id' => 'poket_nnotice_typography',
            'type' => 'info',
            'title' => esc_html__('Welcome Our Global Color Option', 'poket'),
        ),
        array(
            'id' => 'poket_nnoticec_typography',
            'type' => 'info',
            'title' => esc_html__('Note: you can change theme color 2 ways. One Global Option. if you set any color from here, it will show everywhere and second option is Every Section. you need to go every section area. there you can find the color option and you need change the color there.', 'poket'),
        ),
    )
));

/*========================
poket Typography FIELD
=========================*/
Redux::setSection($opt_name, array(
    'title' => esc_html__('Global Typography', 'poket'),
    'id' => 'poket_tyfo_page',
    'icon' => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields' => array(
        array(
            'id' => 'poket_gbtf',
            'type' => 'typography',
            'title' => esc_html__('Global Body Typography', 'poket'),
            'google' => true,
            'font-backup' => true,
            'line-height' => false,
            'text-align' => false,
            'color' => false,
            'output' => array(
                '
						body,p						
					'
            ),
            'units' => 'px',
            'subtitle' => esc_html__('Typography option with each property can be called individually.', 'poket'),
            'default' => array(
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
            ),
        ),
        array(
            'id' => 'poket_ghtf',
            'type' => 'typography',
            'title' => esc_html__('Global Heading Typography', 'poket'),
            'google' => true,
            'font-backup' => true,
            'line-height' => false,
            'text-align' => false,
            'color' => false,
            'output' => array(
                '
						h1,
						h2,
						h3,
						h4,
						h5,
						h6,
						h1 a,
						h2 a,
						h3 a,
						h4 a,
						h5 a,
						h6 a,
						.poket_cauthor_name a		
					'
            ),
            'units' => 'px',
            'subtitle' => esc_html__('Typography option with each property can be called individually.', 'poket'),
            'default' => array(
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
            ),
        ),
        array(
            'id' => 'poket_gmtf',
            'type' => 'typography',
            'title' => esc_html__('Global Menu Typography', 'poket'),
            'google' => true,
            'font-backup' => true,
            'line-height' => false,
            'text-align' => false,
            'color' => false,
            'output' => array(
                '.poket_menu > ul > li > a,.poket_menu ul .sub-menu li a						
				'
            ),
            'units' => 'px',
            'subtitle' => esc_html__('Typography option with each property can be called individually.', 'poket'),
            'default' => array(
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
            ),
        ),
        array(
            'id' => 'poket_gbtnf',
            'type' => 'typography',
            'title' => esc_html__('Global Button Typography', 'poket'),
            'google' => true,
            'font-backup' => true,
            'line-height' => false,
            'text-align' => false,
            'color' => false,
            'font-size' => false,
            'output' => array(
                '
						button,a.btn,a.dtbtn,.btn,.learn_btn,.witr_feature_btn_f a,.witr_feature_btn_3d a,.feature_btn a,.witr_ser_btnb a,.service-btn > a,.witr_btn,.witr_bbtn,.witr_gbtn,.witr_gbbtn,.poket_button a,.witr_sbtn_s8 a,
						.blog_readmore a						
					'
            ),
            'units' => 'px',
            'subtitle' => esc_html__('Typography option with each property can be called individually.', 'poket'),
            'default' => array(
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
            ),
        ),

    ),
));

/*  global color */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Global Color', 'poket'),
    'id' => 'twr_title_option',
    'subsection' => true,
    'icon' => 'el el-circle-arrow-right',
    'fields' => array(
        array(
            'id' => 'twr_bbc',
            'type' => 'color',
            'title' => esc_html__('Body Backgroung Color', 'poket'),
            'default' => '',
            'output' => array(
                'background-color' => 'body'
            )
        ),
        array(
            'id' => 'poket_gprimary',
            'type' => 'color',
            'title' => esc_html__('Theme Color', 'poket'),
            'default' => ''
        ),
        array(
            'id' => 'poket_ghprimary',
            'type' => 'color',
            'title' => esc_html__('Theme Hover Color', 'poket'),
            'default' => ''
        ),
        array(
            'id' => 'poket_alborder',
            'type' => 'color',
            'title' => esc_html__('Theme Border Color', 'poket'),
            'default' => ''
        ),
        array(
            'id' => 'poket_alborderh',
            'type' => 'color',
            'title' => esc_html__('Theme Border Hover Color', 'poket'),
            'default' => ''
        ),
        array(
            'id' => 'poket_linkabtn',
            'type' => 'color',
            'title' => esc_html__('Theme Button & Link Color', 'poket'),
            'default' => ''
        ),
        array(
            'id' => 'poket_altitle',
            'type' => 'color',
            'title' => esc_html__('Theme Title Color', 'poket'),
            'default' => ''
        ),
        array(
            'id' => 'poket_alpra',
            'type' => 'color',
            'title' => esc_html__('Theme Pragraph Color', 'poket'),
            'default' => ''
        ),
        array(
            'id' => 'poket_alwhite',
            'type' => 'color',
            'title' => esc_html__('Theme White Text & BG Place Color', 'poket'),
            'default' => ''
        ),
        array(
            'id' => 'poket_allopcity',
            'type' => 'color_rgba',
            'title' => esc_html__('Theme Box Shadow Color', 'poket'),
            'default' => array(
                'color' => '',
                'alpha' => 1
            )
        ),
        array(
            'id' => 'poket_galbgo',
            'type' => 'color_rgba',
            'title' => esc_html__('Theme Overlay BG Color', 'poket'),
            'default' => array(
                'color' => '',
                'alpha' => 1
            )
        ),

    ),
));

/*========================
END poket global color  FIELD
=========================*/

/* preloader option */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Preloader Option', 'poket'),
    'id' => 'preloderoption',
    'icon' => 'el-icon-cog',
    'fields' => array(
        array(
            'id' => 'twr_is_preloader',
            'type' => 'switch',
            'title' => esc_html__('Preloader', 'poket'),
            'on' => esc_html__('ON', 'poket'),
            'off' => esc_html__('OFF', 'poket'),
            'default' => false,
        ),

        array(
            'required' => array('twr_is_preloader', '=', '1'),
            'id' => 'twr_preloader_style',
            'type' => 'select',
            'title' => esc_html__('Preloader Style', 'poket'),
            'default' => '1',
            'options' => array(
                '1' => esc_html__('Text Preloader Style', 'poket'),
                '2' => esc_html__('Image Preloader Style', 'poket')
            )
        ),

        /**
         * Text Preloader
         */
        array(
            'required' => array('twr_is_preloader', '=', '1'),
            'id' => 'preloader_text',
            'type' => 'text',
            'title' => esc_html__('Preloader Logo Text', 'poket'),
            'default' => get_bloginfo('name')
        ),

        array(
            'required' => array('twr_is_preloader', '=', '1'),
            'title' => esc_html__('Loading Text Color', 'poket'),
            'id' => 'preloader_color',
            'type' => 'color',
            'output' => array(
                '.twr_pretwr_loader_pre .twr_animation .twr_text_pre, .twr_pretwr_loader_pre .twr_animation .twr_text_pre .twr_textletter_pre:before'
            ),
        ),
        array(
            'required' => array('twr_is_preloader', '=', '1'),
            'id' => 'twr_circle_colorbg',
            'type' => 'color',
            'title' => esc_html__(' Spinning Circle Color', 'poket'),
            'default' => '',
            'output' => array(
                'border-bottom-color' => '.twr_pretwr_loader_pre .twr_animation .twr_circle_pre',
                'border-top-color' => '.twr_pretwr_loader_pre .twr_animation .twr_circle_pre'
            )
        ),
        array(
            'required' => array('twr_is_preloader', '=', '1'),
            'title' => esc_html__('Backend Shadow Color', 'poket'),
            'id' => 'preloader_shadow_color',
            'type' => 'color_rgba',
            'output' => array(
                '.twr_pretwr_loader_pre .twr_animation .twr_text_pre .twr_textletter_pre'
            ),
        ),
        array(
            'required' => array('twr_is_preloader', '=', '1'),
            'title' => esc_html__('Loading Logo Typography', 'poket'),
            'id' => 'preloader_typo',
            'type' => 'typography',
            'text-align' => false,
            'color' => false,
            'output' => array(
                '.twr_pretwr_loader_pre .twr_animation .twr_text_pre,.twr_pretwr_loader_pre .twr_animation .twr_text_pre .twr_textletter_pre:before'
            ),
        ),
        array(
            'required' => array('twr_is_preloader', '=', '1'),
            'id' => 'pre_preloader_image',
            'type' => 'media',
            'desc' => esc_html__('Insert gif image for the better look', 'poket'),
            'title' => esc_html__('Preloader image', 'poket'),
            'compiler' => true,
            'default' => array(
                'url' => ''
            )
        ),

        array(
            'required' => array('twr_is_preloader', '=', '1'),
            'id' => 'pre_preloader_text',
            'type' => 'text',
            'title' => esc_html__('Loding Text', 'poket'),
            'desc' => esc_html__('Insert Loading Text Here. Not use the text, remove the text from field.', 'poket'),
            'default' => esc_html__('Please Wait For Loading', 'poket')
        ),
        array(
            'required' => array('twr_is_preloader', '=', '1'),
            'title' => esc_html__('Loading Text Typography', 'poket'),
            'id' => 'preloader_small_typo',
            'type' => 'typography',
            'text-align' => false,
            'output' => array(
                '.twr_pretwr_loader_pre p'
            ),
        ),

        array(
            'required' => array('twr_is_preloader', '=', '1'),
            'id' => 'poket_preceross_hide',
            'type' => 'switch',
            'title' => esc_html__('Loading Cancel Show/Hide', 'poket'),
            'default' => false,
        ),
        array(
            'required' => array('twr_is_preloader', '=', '1'),
            'id' => 'preloader_cancel_icon',
            'type' => 'text',
            'title' => esc_html__('Loding Cancel Icon', 'poket'),
            'desc' => esc_html__('insert icon here. Use themify Icon ex = ti-close or icofont-close go https://themify.me/themify-icons or https://icofont.com/icons . Not use the field, remove the text from field..', 'poket'),
            'default' => esc_html__('ti-close', 'poket'),
        ),
        array(
            'required' => array('twr_is_preloader', '=', '1'),
            'id' => 'preloader_cancel_text',
            'type' => 'text',
            'title' => esc_html__('Loding Cancel Text', 'poket'),
            'desc' => esc_html__('Insert Loading Cancel Text. Not use the text, remove the text from field.', 'poket'),
            'default' => esc_html__('Cancel Loading', 'poket')
        ),
        array(
            'required' => array('twr_is_preloader', '=', '1'),
            'title' => esc_html__('Loading Cancel Text Color', 'poket'),
            'id' => 'preloader_cancel_color',
            'type' => 'color',
            'output' => array(
                '.twr_precross'
            ),
        ),

    )
));

/* total header area */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Header area', 'poket'),
    'id' => 'poket_header_area',
    'desc' => esc_html__('Header options', 'poket'),
    'icon' => 'el-icon-tasks',
    'fields' => array(

        array(
            'id' => 'poket_header_display_none_hide',
            'desc' => esc_html__('All Menu OFF/ON section', 'poket'),
            'type' => 'switch',
            'title' => esc_html__('All Header Hide', 'poket'),
            'default' => false,
        ),
        array(
            'id' => 'poket_header_posi_top',
            'desc' => esc_html__('All Menu Position  OFF/ON section', 'poket'),
            'type' => 'switch',
            'title' => esc_html__('All Header absolute', 'poket'),
            'default' => false,
        ),
        array(
            'id' => 'poket_header_posi_top2',
            'desc' => esc_html__('Top 2 and Main Menu Position  OFF/ON section', 'poket'),
            'type' => 'switch',
            'title' => esc_html__('Top 2 and Main Menu Header absolute', 'poket'),
            'default' => false,
        ),
        array(
            'id' => 'poket_header_posi_top3',
            'desc' => esc_html__('Main Menu Position  OFF/ON section', 'poket'),
            'type' => 'switch',
            'title' => esc_html__('Main Header absolute', 'poket'),
            'default' => false,
        ),


    )
));

/* Header Top 1 */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Header Top Menu 1', 'poket'),
    'id' => 'poket_header_top',
    'desc' => esc_html__('Insert header top info', 'poket'),
    'icon' => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields' => array(
        array(
            'id' => 'poket_header_top_hide',
            'desc' => esc_html__('If you ON this section. It will show header top style everywhere. But If you want to show header top style of your choose post and page. That time, Please don\'t ON the option. For this go to your page or post below, there you can see a Top Menu 1 OFF/ON option. Please select OFF/ON from there.', 'poket'),
            'type' => 'switch',
            'title' => esc_html__('Header Top', 'poket'),
            'default' => false,
        ),
        array(
            'id' => 'poket_box_layout',
            'type' => 'select',
            'title' => esc_html__('Select Top 1 Header layout', 'poket'),
            'customizer_only' => false,
            'options' => array(
                'htops_box' => esc_html__('Select Layout', 'poket'),
                'htopt_box' => esc_html__('Box Layout', 'poket'),
                'htopt_boxi' => esc_html__('Box Inner Layout', 'poket'),
                'htopt_full' => esc_html__('Full Layout', 'poket'),
            ),
            'default' => 'htops_box'
        ),
        array(
            'id' => 'twr_top_right_layout',
            'type' => 'select',
            'title' => esc_html__('Select Top Header Style', 'poket'),
            'customizer_only' => false,
            'options' => array(
                'h_top_l11' => esc_html__('Select Top Menu', 'poket'),
                'top1' => esc_html__('Left: Address and Right: Menu, Open Hours, Icon, Welcome, Login, Search', 'poket'),
                'top2' => esc_html__('Left: Address, Middle: Welcome, Open Hours and Right: Menu, Icon, Login, Search', 'poket'),
                'top3' => esc_html__('Left: Address, Open Hours, Middle: Welcome,Icon and Right: Menu, Login, Search', 'poket'),
                'top4' => esc_html__('Center All Item', 'poket'),
            ),
            'default' => 'top1'
        ),
        array(
            'id' => 'topflex_select',
            'type' => 'select',
            'title' => esc_html__('Menu Direction', 'poket'),
            'customizer_only' => false,
            'options' => array(
                'flex-row' => esc_html__('Row', 'poket'),
                'flex-row-reverse' => esc_html__('Row Reverse', 'poket'),
                'flex-column' => esc_html__('Column', 'poket'),
                'flex-column-reverse' => esc_html__('Column Reverse', 'poket'),
            ),
            'default' => 'flex-row'
        ),
        array(
            'id' => 'top_address_hide',
            'type' => 'switch',
            'title' => esc_html__('Address Section', 'poket'),
            'default' => true,
        ),
        array(
            'id' => 'top_icon_hide',
            'type' => 'switch',
            'title' => esc_html__('Social Icon Section', 'poket'),
            'default' => true,
        ),
        array(
            'id' => 'top_search_hide',
            'type' => 'switch',
            'title' => esc_html__('Search Section', 'poket'),
            'default' => false,
        ),
        array(
            'id' => 'top_menu_hide',
            'type' => 'switch',
            'title' => esc_html__('Menu Section', 'poket'),
            'default' => false,
        ),
        array(
            'id' => 'top_login_hide',
            'type' => 'switch',
            'title' => esc_html__('Login Section', 'poket'),
            'default' => false,
        ),
        array(
            'id' => 'top_welcome_hide',
            'type' => 'switch',
            'title' => esc_html__('Text Message Section', 'poket'),
            'default' => false,
        ),
        array(
            'id' => 'top_opening_hide',
            'type' => 'switch',
            'title' => esc_html__('Opening Hours Section', 'poket'),
            'default' => true,
        ),

        array(
            'required' => array('top_address_hide', '=', 'true'),
            'id' => 'poket_header_top_i1',
            'type' => 'text',
            'title' => esc_html__('Set Location Icon', 'poket'),
            'desc' => esc_html__('insert icofont icon here. ex - <i class="ti-home"></i> go https://themify.me/themify-icons. Not use the field, remove the text from field', 'poket'),
            'default' => esc_html__('<i class="ti-home"></i>', 'poket'),
        ),
        array(
            'required' => array('top_address_hide', '=', 'true'),
            'id' => 'poket_header_top_road',
            'type' => 'text',
            'title' => esc_html__('Location Name', 'poket'),
            'desc' => esc_html__('Insert Your Text', 'poket'),
            'default' => esc_html__('1st Floor New World.', 'poket'),
        ),
        array(
            'required' => array('top_address_hide', '=', 'true'),
            'id' => 'poket_header_top_i2',
            'type' => 'text',
            'title' => esc_html__('Set Phone Icon', 'poket'),
            'desc' => esc_html__('insert icofont icon here. ex - <i class="ti-mobile"></i> go https://themify.me/themify-icons. Not use the field, remove the text from field', 'poket'),
            'default' => esc_html__('<i class="ti-mobile"></i>', 'poket'),
        ),
        array(
            'required' => array('top_address_hide', '=', 'true'),
            'id' => 'poket_header_top_mobile',
            'type' => 'text',
            'title' => esc_html__('Phone Number', 'poket'),
            'desc' => esc_html__('Insert Your Phone Number Text', 'poket'),
            'default' => esc_html__('+998556778345', 'poket'),
        ),
        array(
            'required' => array('top_address_hide', '=', 'true'),
            'id' => 'poket_header_top_i3',
            'type' => 'text',
            'title' => esc_html__('Set Email Icon', 'poket'),
            'desc' => esc_html__('insert icofont icon here. ex - <i class="ti-email"></i> go https://themify.me/themify-icons. Not use the field, remove the text from field', 'poket'),
            'default' => esc_html__('<i class="ti-email"></i>', 'poket'),
        ),
        array(
            'required' => array('top_address_hide', '=', 'true'),
            'id' => 'poket_header_top_email',
            'type' => 'text',
            'title' => esc_html__('Email ID', 'poket'),
            'desc' => esc_html__('Insert Your Text', 'poket'),
            'default' => esc_html__('demo@example.com', 'poket'),
        ),
        array(
            'required' => array('top_welcome_hide', '=', 'true'),
            'id' => 'poket_header_top_i4',
            'type' => 'text',
            'title' => esc_html__('Set Message Icon', 'poket'),
            'desc' => esc_html__('insert icofont icon here. ex - <i class="ti-crown"></i> go https://themify.me/themify-icons. Not use the field, remove the text from field', 'poket'),
            'default' => esc_html__('<i class="ti-crown"></i>', 'poket'),
        ),
        array(
            'required' => array('top_welcome_hide', '=', 'true'),
            'id' => 'poket_header_top_wellcome',
            'type' => 'text',
            'title' => esc_html__('Text Message', 'poket'),
            'desc' => esc_html__('Insert text support - span,a,br,strong,b,em and h2 html tag', 'poket'),
            'default' => esc_html__('welcome visit our site', 'poket'),
        ),
        array(
            'required' => array('top_opening_hide', '=', 'true'),
            'id' => 'poket_header_top_i5',
            'type' => 'text',
            'title' => esc_html__('Set Open Icon', 'poket'),
            'desc' => esc_html__('insert icofont icon here. ex - <i class="ti-time"></i> go https://themify.me/themify-icons. Not use the field, remove the text from field', 'poket'),
            'default' => esc_html__('<i class="ti-time"></i>', 'poket'),
        ),
        array(
            'required' => array('top_opening_hide', '=', 'true'),
            'id' => 'poket_header_top_opening',
            'type' => 'text',
            'title' => esc_html__('Opening Text', 'poket'),
            'desc' => esc_html__('Insert Text', 'poket'),
            'default' => esc_html__('Open hours: 9am-6pm', 'poket'),
        ),
        array(
            'id' => 'poket_header_top_color',
            'type' => 'color',
            'title' => esc_html__('All Text Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.top-address p a,
								.top-right-menu ul.social-icons li a,
								.top-address p span,
								.top-address.menu_18 span,
								.top-welcome p span,
								.top-welcomet p span,.top-address p span i, .top-address p a i,.top-welcome p span i,
								.ossos .em-quearys-menu i
					'
            )
        ),
        array(
            'id' => 'poket_htic',
            'type' => 'color',
            'title' => esc_html__('Top Icon Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.top-address p span i, .top-address p a i,.top-right-menu .social-icons li a,.top-welcome p span i
				'
            )
        ),
        array(
            'id' => 'poket_htich',
            'type' => 'color',
            'title' => esc_html__('All Icon Hover Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.top-right-menu .social-icons li a:hover,
								.top-right-menu .social-icons li a i:hover,
								.top-address p a i:hover,
								.top-address p span i:hover
					'
            )
        ),
        /*array(
                    'id'        => 'poket_header_top_wella_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Text Message Link Color', 'poket'),
                    'default'  => '',
        'output'    => array(
        'color' => '.top-welcome p a,.top-address p a'
        )
                ),
        array(
                    'id'        => 'poket_header_hover_Link_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Text Message Link Hover Color', 'poket'),
                    'default'  => '',
        'output'    => array(
        'color' => '.top-welcome p a:hover,.top-welcomet p a:hover,.top-address p a:hover'
        )
                ),	*/
        array(
            'id' => 'poket_htibgc',
            'type' => 'background',
            'title' => esc_html__('Header Top Section BG Color', 'poket'),
            'default' => '',
            'output' => array(
                '
				.poket-header-top,.top-right-menu ul .sub-menu
				'
            ),
            'default' => array(
                'background-color' => '',
            )
        ),
        array(
            'id' => 'top_menu_gr',
            'type' => 'color_gradient',
            'title' => esc_html__('HeaderTop Menu Section Gradient BG Color', 'poket'),
            'desc' => esc_html__('Set Gradient From here.', 'poket'),
            'validate' => 'color',
            'default' => array(
                'from' => '',
                'to' => '',
            )
        ),
        array(
            'id' => 'top_header_border',
            'type' => 'border',
            'title' => __('Header Border Option', 'poket'),
            'subtitle' => __('Only color validation can be done on this field type', 'poket'),
            'output' => array(
                '.poket-header-top'
            ),
            'desc' => __('This is the description field, again good for additional info.', 'poket'),
            'default' => array(
                'border-color' => '',
                'border-style' => 'solid',
                'border-top' => '',
                'border-right' => '',
                'border-bottom' => '',
                'border-left' => ''
            )
        ),

        array(
            'id' => 'poket_htpds',
            'type' => 'spacing',
            'output' => array(
                '.poket-header-top'
            ),
            'mode' => 'padding',
            'units' => array(
                'em',
                'px'
            ),
            'units_extended' => 'false',
            'title' => esc_html__('Padding Option', 'poket'),
            'subtitle' => esc_html__('Allow your users to choose the spacing padding they want.', 'poket'),
            'desc' => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'poket'),
            'default' => array(
                'padding-top' => '',
                'padding-right' => '',
                'padding-bottom' => '',
                'padding-left' => '',
                'units' => 'px',
            )
        ),

    ),
));

/* Header Top 2 */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Header Top Menu 2', 'poket'),
    'id' => 'poket_header_toptwo',
    'desc' => esc_html__('Insert header top info', 'poket'),
    'icon' => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields' => array(
        array(
            'id' => 'poket_header_top_two_hide',
            'desc' => esc_html__('If you ON this section. It will show header top style 2 everywhere. But If you want to show header top style 2 your choose page and post. That time, Please don\'t ON the option. For this go to your page or post below, there you can see a Top Menu 2 OFF/ON option. Please select OFF/ON from there.', 'poket'),
            'type' => 'switch',
            'title' => esc_html__('Header Top style 2', 'poket'),
            'default' => false,
        ),
        array(
            'id' => 'poket_box_layouttwo',
            'type' => 'select',
            'title' => esc_html__('Select Top 2 Header layout', 'poket'),
            'customizer_only' => false,
            'options' => array(
                'htops_box' => esc_html__('Select Layout', 'poket'),
                'htopt_box' => esc_html__('Box Layout', 'poket'),
                'htopt_boxi' => esc_html__('Box Inner Layout', 'poket'),
                'htopt_full' => esc_html__('Full Layout', 'poket'),
            ),
            'default' => 'htops_box'
        ),
        array(
            'id' => 'twr_top_two_layout',
            'type' => 'select',
            'title' => esc_html__('Select Top 2 Header Style', 'poket'),
            'customizer_only' => false,
            'options' => array(
                'h_middle1' => esc_html__('Select Top Menu', 'poket'),
                'middle1' => esc_html__('1. Left Logo,Middle Address And Right Top Menu, Social Icon, Shop, Button', 'poket'),
                'middle2' => esc_html__('2. Left Address, Middle Logo And Right Top Menu, Social Icon, Shop, Button', 'poket'),
            ),
            'default' => 'middle1'
        ),
        array(
            'id' => 'middleflex_select',
            'type' => 'select',
            'title' => esc_html__('Menu Direction', 'poket'),
            'customizer_only' => false,
            'options' => array(
                'flex-row' => esc_html__('Row', 'poket'),
                'flex-row-reverse' => esc_html__('Row Reverse', 'poket'),
                'flex-column' => esc_html__('Column', 'poket'),
                'flex-column-reverse' => esc_html__('Column Reverse', 'poket'),
            ),
            'default' => 'flex-row'
        ),
        array(
            'id' => 'middle_address_hide',
            'type' => 'switch',
            'title' => esc_html__('Address Section', 'poket'),
            'default' => true,
        ),
        array(
            'id' => 'middle_icon_hide',
            'type' => 'switch',
            'title' => esc_html__('Social Icon Section', 'poket'),
            'default' => true,
        ),
        array(
            'id' => 'middle_menu_hide',
            'type' => 'switch',
            'title' => esc_html__('Menu Section', 'poket'),
            'default' => false,
        ),
        array(
            'id' => 'middle_logo_hide',
            'type' => 'switch',
            'title' => esc_html__('Logo Section', 'poket'),
            'default' => true,
        ),
        array(
            'id' => 'middle_woo_hide',
            'type' => 'switch',
            'title' => esc_html__('WooCommerce Section', 'poket'),
            'default' => false,
        ),
        array(
            'id' => 'middle_button_hide',
            'type' => 'switch',
            'title' => esc_html__('Button Section', 'poket'),
            'default' => false,
        ),

        array(
            'required' => array('middle_address_hide', '=', 'true'),
            'id' => 'poket_header_top_ci1',
            'type' => 'text',
            'title' => esc_html__('Set Location Icon', 'poket'),
            'desc' => esc_html__('insert icofont icon here. ex - <i class="ti-location-pin"></i> go https://themify.me/themify-icons . Not use the field, remove the text from field', 'poket'),
            'default' => esc_html__('<i class="ti-location-pin"></i>', 'poket'),
        ),
        array(
            'required' => array('middle_address_hide', '=', 'true'),
            'id' => 'poket_header_top_roadtwot',
            'type' => 'text',
            'title' => esc_html__('Location Title', 'poket'),
            'desc' => esc_html__('Insert Text Here', 'poket'),
            'default' => esc_html__('Location', 'poket'),
        ),
        array(
            'required' => array('middle_address_hide', '=', 'true'),
            'id' => 'poket_header_top_roadtwo',
            'type' => 'text',
            'title' => esc_html__('Location Sub Title', 'poket'),
            'desc' => esc_html__('Insert Text Here', 'poket'),
            'default' => esc_html__('1st Floor.', 'poket'),
        ),
        array(
            'required' => array('middle_address_hide', '=', 'true'),
            'id' => 'poket_header_top_ci2',
            'type' => 'text',
            'title' => esc_html__('Set Email Icon', 'poket'),
            'desc' => esc_html__('insert icofont icon here. ex - <i class="ti-email"></i> . Not use the field, remove the text from field', 'poket'),
            'default' => esc_html__('<i class="ti-email"></i>', 'poket'),
        ),
        array(
            'required' => array('middle_address_hide', '=', 'true'),
            'id' => 'poket_header_top_emailtwot',
            'type' => 'text',
            'title' => esc_html__('Email Title', 'poket'),
            'desc' => esc_html__('insert info', 'poket'),
            'default' => esc_html__(' Email', 'poket'),
        ),
        array(
            'required' => array('middle_address_hide', '=', 'true'),
            'id' => 'poket_header_top_emailtwo',
            'type' => 'text',
            'title' => esc_html__('Email Sub Title', 'poket'),
            'desc' => esc_html__('Iinsert info', 'poket'),
            'default' => esc_html__('demo@example.com', 'poket'),
        ),
        array(
            'required' => array('middle_address_hide', '=', 'true'),
            'id' => 'poket_header_top_ci3',
            'type' => 'text',
            'title' => esc_html__('Set Phone Icon', 'poket'),
            'desc' => esc_html__('insert icofont icon here. ex - <i class="ti-mobile"></i> . Not use the field, remove the text from field', 'poket'),
            'default' => esc_html__('<i class="ti-mobile"></i>', 'poket'),
        ),
        array(
            'required' => array('middle_address_hide', '=', 'true'),
            'id' => 'poket_header_top_mobiletwot',
            'type' => 'text',
            'title' => esc_html__('Phone Title', 'poket'),
            'desc' => esc_html__('insert info', 'poket'),
            'default' => esc_html__('Phone', 'poket'),
        ),
        array(
            'required' => array('middle_address_hide', '=', 'true'),
            'id' => 'poket_header_top_mobiletwo',
            'type' => 'text',
            'title' => esc_html__('Phone Number', 'poket'),
            'desc' => esc_html__('insert info', 'poket'),
            'default' => esc_html__('+998556778345', 'poket'),
        ),
        array(
            'required' => array('middle_button_hide', '=', 'true'),
            'id' => 'poket_header_buttonc1',
            'type' => 'text',
            'title' => esc_html__('Button Text', 'poket'),
            'desc' => esc_html__('Insert text here, Not use the button, remove the text from field', 'poket'),
            'default' => esc_html__('Get a Quote', 'poket'),
        ),
        array(
            'required' => array('middle_button_hide', '=', 'true'),
            'id' => 'poket_header_button_urlc1',
            'type' => 'text',
            'title' => esc_html__('Button URL', 'poket'),
            'desc' => esc_html__('Insert url ex: - https://your_site.com/ and Not use the link, remove the link from field', 'poket'),
            'default' => '#',
        ),
        array(
            'id' => 'poket_httic',
            'type' => 'color',
            'title' => esc_html__('Top Icon Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.creative_header_icon i
					'
            )
        ),
        array(
            'id' => 'poket_httibg',
            'type' => 'color',
            'title' => esc_html__('Top Icon BG Color', 'poket'),
            'default' => '',
            'output' => array(
                'background-color' => '.creative_header_icon i',
            )
        ),
        array(
            'id' => 'poket_httipd',
            'type' => 'spacing',
            'output' => array(
                '.creative_header_icon i'
            ),
            'mode' => 'padding',
            'units' => array(
                'em',
                'px'
            ),
            'units_extended' => 'false',
            'title' => esc_html__('Top Icon Padding Option', 'poket'),
            'subtitle' => esc_html__('Allow your users to choose the spacing padding they want.', 'poket'),
            'desc' => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'poket'),
            'default' => array(
                'padding-top' => '',
                'padding-right' => '',
                'padding-bottom' => '',
                'padding-left' => '',
                'units' => 'px',
            )
        ),

        array(
            'id' => 'poket_htttf',
            'type' => 'typography',
            'title' => esc_html__('Title Typography style', 'poket'),
            'google' => true,
            'font-backup' => true,
            'output' => array(
                '.creative_header_address_text > h3'
            ),
            'line-height' => false,
            'units' => 'px',
            'subtitle' => esc_html__('Typography option with each property can be called individually.', 'poket'),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            ),
        ),
        array(
            'id' => 'poket_httstf',
            'type' => 'typography',
            'title' => esc_html__('Sub Title Typography style', 'poket'),
            'google' => true,
            'font-backup' => true,
            'output' => array(
                '.creative_header_address_text > p,.creative_header_address_text > p > a,.top_crmenu_l li a,.cr_top_addess p span,.cr_top_addess p a'
            ),
            'line-height' => false,
            'units' => 'px',
            'subtitle' => esc_html__('Typography option with each property can be called individually.', 'poket'),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            ),
        ),
        array(
            'id' => 'poket_httbbg',
            'type' => 'color',
            'title' => esc_html__('Button BG Color', 'poket'),
            'default' => '',
            'output' => array(
                'background-color' => '
				.tx_menuc_btn .tx_mc_btn,.top_crmenu_l ul, .top_crt_style,
				.creative_header_button .dtbtn,
				.mini_shop_content a span.count
				',
                'border-color' => '.creative_header_button .dtbtn'
            )
        ),
        array(
            'id' => 'poket_httbbgh',
            'type' => 'color',
            'title' => esc_html__('Button BG Hover Color', 'poket'),
            'default' => '',
            'output' => array(
                'background-color' => '
				.tx_menuc_btn .tx_mc_btn:hover,
				.creative_header_button .dtbtn:hover
				',
                'border-color' => '
				.tx_menuc_btn .tx_mc_btn:hover,
				.creative_header_button .dtbtn:hover
				'
            )
        ),
        array(
            'id' => 'poket_httscbg',
            'type' => 'background',
            'title' => esc_html__('Header Top Section BG Color', 'poket'),
            'default' => '',
            'output' => array(
                '.em_creative_header,.top_crt_style
				'
            ),
            'default' => array(
                'background-color' => '',
            )
        ),

        array(
            'id' => 'poket_httscpd',
            'type' => 'spacing',
            'output' => array(
                '.em_creative_header,.top_crt_style'
            ),
            'mode' => 'padding',
            'units' => array(
                'em',
                'px'
            ),
            'units_extended' => 'false',
            'title' => esc_html__('Padding Option', 'poket'),
            'subtitle' => esc_html__('Allow your users to choose the spacing padding they want.', 'poket'),
            'desc' => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'poket'),
            'default' => array(
                'padding-top' => '',
                'padding-right' => '',
                'padding-bottom' => '',
                'padding-left' => '',
                'units' => 'px',
            )
        ),

    ),
));

/* Header Logo */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Header Menu Logo', 'poket'),
    'id' => 'poket_header_logo',
    'desc' => esc_html__('Header Logo', 'poket'),
    'icon' => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields' => array(
        array(
            'id' => 'poket_logo',
            'type' => 'media',
            'title' => esc_html__('Default Logo', 'poket'),
            'compiler' => 'true',
            'mode' => false,
            'desc' => esc_html__('Upload logo here.ex: - it is work in default menu.', 'poket'),
        ),
        array(
            'id' => 'poket_onepage_logo',
            'type' => 'media',
            'title' => esc_html__('One Page Menu Logo', 'poket'),
            'compiler' => 'true',
            'mode' => false,
            'desc' => esc_html__('Upload logo here. ex:- it is work in one page menu', 'poket'),
        ),
        array(
            'id' => 'poket_ts_logo',
            'type' => 'media',
            'title' => esc_html__('Transparent Menu Logo', 'poket'),
            'compiler' => 'true',
            'mode' => false,
            'desc' => esc_html__('Upload logo here. ex: - it is work in transparent menu', 'poket'),
        ),
        array(
            'id' => 'poket_mobile_top_logo',
            'type' => 'media',
            'title' => esc_html__('Mobile Logo', 'poket'),
            'compiler' => 'true',
            'mode' => false,
            'desc' => esc_html__('Upload logo here. recommend size:- 180x48px.', 'poket'),
        ),
        array(
            'id' => 'poket_logo_height',
            'type' => 'text',
            'title' => esc_html__('Logo Height', 'poket'),
            'mode' => false,
            'desc' => esc_html__('Set height ex-100px', 'poket'),
        ),
        array(
            'id' => 'poket_logo_widget',
            'type' => 'text',
            'title' => esc_html__('Logo Width', 'poket'),
            'mode' => false,
            'desc' => esc_html__('Set Width ex-100px', 'poket'),
        ),
        array(
            'id' => 'poket_line_height',
            'type' => 'text',
            'title' => esc_html__('Set your logo spacing to Menu ', 'poket'),
            'mode' => false,
            'desc' => esc_html__('Set number default-15px', 'poket'),
            'default' => '',
        ),
        array(
            'id' => 'twr_hlogoc',
            'type' => 'color',
            'desc' => esc_html__('Set Logo color', 'poket'),
            'title' => esc_html__('Text Logo Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '
				.top_crt_style .site-title a
				',
            )
        ),



    ),
));
/* Mobile Logo */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Mobile Menu Logo', 'poket'),
    'id' => 'poket_mlogos',
    'icon' => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields' => array(
        array(
            'id' => 'poket_mobile_top_logo',
            'type' => 'media',
            'title' => esc_html__('Mobile Menu Logo', 'poket'),
            'compiler' => 'true',
            'mode' => false,
            'desc' => esc_html__('Upload logo here. recommend size:- 180x48px.', 'poket'),
        ),
        array(
            'id' => 'twr_mlogoc',
            'type' => 'color',
            'desc' => esc_html__('Set Logo color', 'poket'),
            'title' => esc_html__('Text Logo Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '
				.mobile_menu_logo  .site-title a
				',
            )
        ),
        array(
            'id' => 'poket_mobilebr_color',
            'type' => 'color',
            'title' => esc_html__('Mobile Menu Border Color', 'poket'),
            'default' => '',
            'output' => array(
                'border-color' => '.mean-container .mean-nav ul li a,.mean-container .mean-nav ul li li a',
            )
        ),
        array(
            'id' => 'mobile_ntext_color',
            'type' => 'color',
            'title' => esc_html__('Mobile Menu Color', 'dellar'),
            'default' => '',
            'output' => array(
                'color' => '.mean-container .mean-nav ul li a,.mean-container .mean-nav ul li li a',
            )
        ),
        array(
            'id' => 'poket_mobilebg_color',
            'type' => 'color',
            'title' => esc_html__('Mobile Menu BG Color', 'poket'),
            'default' => '',
            'output' => array(
                'background-color' => '.mobile_logo_area,.mobile_p',
            )
        ),
        array(
            'id' => 'poket_mobileicon_color',
            'type' => 'color',
            'title' => esc_html__('Mobile Menu Icon Color', 'poket'),
            'default' => '',
            'output' => array(
                'background-color' => '',
                'color' => '.mobile_menu_o i'
            )
        ),

    ),
));

/* Header Menu */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Main Menu', 'poket'),
    'id' => 'poket_menu',
    'icon' => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields' => array(
        array(
            'id' => 'poket_main_box_layout',
            'type' => 'select',
            'title' => esc_html__('Select Header Menu layout', 'poket'),
            'customizer_only' => false,
            'options' => array(
                'htops_box' => esc_html__('Select Layout', 'poket'),
                'hmenul_box' => esc_html__('Box Layout', 'poket'),
                'hmenul_boxi' => esc_html__('Box Inner Layout', 'poket'),
                'hmenu_full' => esc_html__('Full Layout', 'poket'),
            ),
            'default' => 'htops_box'
        ),
        array(
            'id' => 'twr_defaulth_menu_layout',
            'desc' => esc_html__('select your menu from here.', 'poket'),
            'type' => 'select',
            'title' => esc_html__('Select Default Menu For All Page', 'poket'),
            'customizer_only' => false,
            'options' => array(
                '111' => esc_html__('Select Menu Style From Here', 'poket'),
                'defaultm' => esc_html__('1 Default Menu', 'poket'),
                'defaultmf' => esc_html__('2 Default sticky Menu', 'poket'),
                'defaultmfclogo' => esc_html__('3 Left Menu, Center Logo, and Right Item', 'poket'),
                'defaultmfnol' => esc_html__('4 Nologo, Header Menu', 'poket'),
                'tm' => esc_html__('5 Header Transparent Menu', 'poket'),
                /*'tms' => esc_html__('6 Header Transparent Sticky Menu, With Other', 'poket'),*/
                'tmsclogo' => esc_html__('7 Transparent Left Menu, Center Logo and Right Item', 'poket'),
                'tmsnol' => esc_html__('8 Transparent Nologo, Left Menu', 'poket'),
                'om' => esc_html__('9 One Page Menu', 'poket'),
                'otm' => esc_html__('10 One Page Transparent Menu', 'poket'),
                /*'otsm' => esc_html__('11 Header One Page Transparent Sticky Menu, With Other', 'poket'),
                'otsmclogo' => esc_html__('12 Left One Page Transparent Menu, Center Logo and Right Item', 'poket'),
                'otsmnol' => esc_html__('13 Nologo, One Page Transparent Menu', 'poket'),*/
                'mbox' => esc_html__('14 Header Box Menu, With Other', 'poket'),
                'mheadroom' => esc_html__('15 Header headroom Menu, With Other', 'poket'),
                'mhamburger' => esc_html__('16 Header Hamburgers Menu, With Other', 'poket'),
                'mpopup' => esc_html__('17 Header Popup Menu', 'poket'),
                'topmain' => esc_html__('18 Top and Main Menu, With Other', 'poket'),
                'blank' => esc_html__('19 Header Menu Hide', 'poket'),
            ),
            'default' => '111'
        ),


        array(
            'id' => 'twr_side_item',
            'type' => 'switch',
            'title' => esc_html__('Main Menu left/Right Item', 'poket'),
            'desc' => esc_html__('Select the Default Item for all pages. But if you want to show the item on your favorite page. For this go to your post/page and edit it and see post/page below. From there select Show/Hide.', 'poket'),
            'default' => false,
        ),
        /* Button Section */
        array(
                'required' => array('twr_side_item', '=', '1'),
                'id'       => 'namesortd',
                'type'    => 'sorter',
                'title'   => esc_html__('Set Item Of Main Menu Area', 'poket'),
                'desc'    => esc_html__('Drag & Drop Of your item', 'poket'),
                'options' => array(
                    'enabled'  => array(
                        'search'     => esc_html__('Search', 'poket'),
                        'button' => esc_html__('Button', 'poket'),
                    ),
                    'disabled' => array(
                        'socialicon' => esc_html__('Social Icon', 'poket'),
                        'popupmicon' => esc_html__('Popup Menu Icon', 'poket'),
                        'login' => esc_html__('Login / Logout', 'poket'),
                        'pnumber'   => esc_html__('Phone Number','poket'),
                        'woicon' => esc_html__('WooCommerce Icon', 'poket'),                   
                    )
                ),
        ),
      /* Main Menu Color */
      array(
        'id' => 'poket_menu_typography',
        'type' => 'typography',
        'title' => esc_html__('Main Menu Color & Typography', 'poket'),
        'google' => true,
        'font-backup' => true,
        'output' => array(
            '
                    .poket_menu > ul > li > a,
                    .heading_style_4 .poket_menu > ul > li > a,
                    .main_menu_header_address_text h3,
                    .main_menu_header_address_text h4 a
                '
        ),
        'line-height' => false,
        'units' => 'px',
        'subtitle' => esc_html__('Typography option with each property can be called individually.', 'poket'),
        'default' => array(
            'color' => '',
            'font-style' => '',
            'font-family' => '',
            'google' => true,
            'font-size' => '',
            'line-height' => ''
        ),
    ),
    array(
        'id' => 'poket_menu_texts_hover_color',
        'type' => 'color',
        'title' => esc_html__('Main Menu Hover Text Color', 'poket'),
        'default' => '',
        'output' => array(
            'color' => '.poket_menu > ul > li > a:hover,.poket_menu > ul > li.current-menu-item > a,.right_sideber_menu i:hover,.main_menu_header_address_text h4 a:hover,.poket_menu ul .sub-menu li:hover > a,.poket_menu ul .sub-menu .sub-menu li:hover > a,.poket_menu ul .sub-menu .sub-menu .sub-menu li:hover > a,.poket_menu ul .sub-menu .sub-menu .sub-menu .sub-menu li:hover > a,.poket_menu ul .sub-menu li:hover:before,.heading_style_4 .poket_menu > ul > li > a:hover,.hbg2 .poket_menu > ul > li > a:hover,.poket_nav_area.prefix .poket_menu>ul>li>a:hover,.poket_menu ul .sub-menu li a:hover,.poket_menu>ul>li>a:hover',

            'background-color' => '.poket_menu > ul > li > a::before,.poket_menu > ul > li.current-menu-item:hover > a::before,.poket_menu > ul > li.current-menu-item > a:before'
        )
    ),
    array(
        'id' => 'poket_mitemm',
        'type' => 'spacing',
        'output' => array(
            '.poket_menu>ul>li>a'
        ),
        'mode' => 'margin',
        'units' => array(
            'em',
            'px'
        ),
        'units_extended' => 'false',
        'title' => esc_html__('Menu Item Spacing Option', 'poket'),
        'subtitle' => esc_html__('Set menu item spacing here.', 'poket'),
        'desc' => esc_html__('Top, Right, Bottom, Left', 'poket'),
        'default' => array(
            'margin-top' => '',
            'margin-right' => '',
            'margin-bottom' => '',
            'margin-left' => '',
            'units' => 'px',
        )
    ),
    array(
        'id' => 'poket_menu_sticky_text_color',
        'type' => 'color',
        'title' => esc_html__('Main Menu Sticky Text Color', 'poket'),
        'default' => '',
        'output' => array(
            'color' => '
                .poket_nav_area.prefix .poket_menu > ul > li > a,.hmenu_box_style.hbg2 .poket_menu > ul > li > a,.hbg2 .poket_menu > ul > li > a,.poket_nav_area.prefix .right_sideber_menu i,.witr_search_wh .prefix  .em-header-quearys .em-quearys-menu i,.poket_nav_area.prefix .poket_menu > ul > li.current > a
                ',
            'background-color' => '
                .poket_nav_area.prefix .poket_menu > ul > li > a::before,
                .hbg2 .poket_menu > ul > li > a::before
                
                '
        )
    ),
    array(
        'id' => 'poket_menu_text_hover_color',
        'type' => 'color',
        'title' => esc_html__('Main Menu & Sticky Menu Current Text Color', 'poket'),
        'default' => '',
        'output' => array(
            'color' => '
                .poket_nav_area.prefix .poket_menu > ul > li.current > a,.hbg2 .poket_menu > ul > li.current > a,.heading_style_4 .poket_menu > ul > li.current-menu-item > a,.hbg2 .poket_menu > ul > li.current-menu-item > a,.poket_nav_area.prefix .poket_menu>ul>li.current-menu-item>a,.poket_menu ul .sub-menu li.current-menu-item a,.poket_menu>ul>li.current-menu-item>a,.poket_menu > ul > li.current-menu-ancestor > a,.poket_menu ul .sub-menu .current-menu-parent > a,.prefix .poket_menu > ul > li.current-menu-ancestor > a
                ',
            'background-color' => '
                    .poket_nav_area.prefix .poket_menu > ul > li.current > a::before					
                '
        )
    ),
    array(
        'id' => 'poket_menu_bg_sticky_color',
        'type' => 'color_rgba',
        'title' => esc_html__('Main Menu Sticky BG Color', 'poket'),
        'default' => array(
            'color' => '#000000',
            'alpha' => .7
        ),
        'output' => array(
            'background-color' => '
                .poket_nav_area.prefix,
                .hbg2
            '
        )
    ),
    array(
        'id' => 'poket_sub_menu_typography',
        'type' => 'typography',
        'title' => esc_html__('Sub Menu Color & Typography', 'poket'),
        'google' => true,
        'font-backup' => true,
        'output' => array(
            '
            .poket_menu ul .sub-menu li a,.poket_menu ul .sub-menu li:before
            '
        ),
        'units' => 'px',
        'subtitle' => esc_html__('Typography option with each property can be called individually.', 'poket'),
        'default' => array(
            'color' => '',
            'font-style' => '',
            'font-family' => '',
            'google' => true,
            'font-size' => '',
            'line-height' => ''
        ),
    ),

    array(
        'id' => 'poket_submenu_hover_text_color',
        'type' => 'color',
        'title' => esc_html__('Sub Menu Hover Color', 'poket'),
        'default' => '',
        'output' => array(
            'color' => '
                    .poket_menu ul .sub-menu li:hover > a,
                    .poket_menu ul .sub-menu .sub-menu li:hover > a,
                    .poket_menu ul .sub-menu .sub-menu .sub-menu li:hover > a,
                    .poket_menu ul .sub-menu .sub-menu .sub-menu .sub-menu li:hover > a,	
                    .poket_menu ul .sub-menu li:hover:before	
                    
                    '
        )
    ),
    array(
        'id' => 'poket_submenu_bg_color',
        'type' => 'background',
        'title' => esc_html__('Sub Menu BG Color', 'poket'),
        'default' => '',
        'output' => array(
            '
            .poket_menu ul .sub-menu
            '
        ),
        'default' => array(
            'background-color' => '',
        )
    ),
         
        array(
            'id' => 'main_button_hide',
            'type' => 'info',
            'title' => esc_html__('Button Color setting ************************', 'poket'),
            'desc' => esc_html__('set your menu button style from here', 'poket'),
        ),
        array(
            'id' => 'poket_header_button',
            'type' => 'text',
            'title' => esc_html__('Button Text', 'poket'),
            'desc' => esc_html__('Insert text here, Not use the button, remove the text from field', 'poket'),
            'default' => esc_html__('Buy Now', 'poket'),
        ),
        array(
            'id' => 'poket_header_button_url',
            'type' => 'text',
            'title' => esc_html__('Button URL', 'poket'),
            'desc' => esc_html__('Insert url ex: - https://your_site.com/  and  Not use the link, remove the link from field', 'poket'),
            'default' => '#',
        ),
        array(
            'id' => 'poket_Button_colorm',
            'type' => 'color',
            'title' => esc_html__('Menu Button Text Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => 'a.dtbtn'
            )
        ),
        array(
            'id' => 'poket_Button_colorurl',
            'type' => 'color',
            'title' => esc_html__('Menu Button BG Color', 'poket'),
            'default' => '',
            'output' => array(
                'background-color' => 'a.dtbtn',
                'border-color' => 'a.dtbtn'
            )
        ),
        array(
            'id' => 'button_bg_gr',
            'type' => 'color_gradient',
            'title' => esc_html__('Menu Button Gradient BG Color', 'poket'),
            'desc' => esc_html__('Set Gradient From here.', 'poket'),
            'validate' => 'color',
            'default' => array(
                'from' => '',
                'to' => '',
            )
        ),
        array(
            'id' => 'poket_Buttonht_colorm',
            'type' => 'color',
            'title' => esc_html__('Menu Button Hover Text Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => 'a.dtbtn:hover'
            )
        ),
        array(
            'id' => 'poket_Buttonhtb_colorurl',
            'type' => 'color',
            'title' => esc_html__('Menu Button Hover BG Color', 'poket'),
            'default' => '',
            'output' => array(
                'background-color' => 'a.dtbtn:hover',
                'border-color' => 'a.dtbtn:hover'
            )
        ),
        array(
            'id' => 'button_bgh_gr',
            'type' => 'color_gradient',
            'title' => esc_html__('Menu Button Hover Gradient BG Color', 'poket'),
            'desc' => esc_html__('Set Gradient From here.', 'poket'),
            'validate' => 'color',
            'default' => array(
                'from' => '',
                'to' => '',
            )
        ),

        /* Search Section */
        array(
            'id' => 'main_search_hide',
            'type' => 'info',
            'title' => esc_html__('Search Color setting ************************', 'poket'),
            'desc' => esc_html__('set your menu search icon style from here', 'poket'),
        ),       
        array(
            'id' => 'poket_search_color',
            'type' => 'color',
            'desc' => esc_html__('Search Icon Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.em-quearys-menu i,.top-form-control button.top-quearys-style'
            )
        ),
        array(
            'id' => 'poket_search_bg',
            'type' => 'color',
            'desc' => esc_html__('Search icon BG Color', 'poket'),
            'default' => '',
            'output' => array(
                'background-color' => '.em-quearys-menu i',
                'border-color' => '.em-quearys-form'
            )
        ),
        array(
            'id' => 'poket_search_hoverbg',
            'type' => 'color',
            'desc' => esc_html__('Search icon BG Hover Color', 'poket'),
            'default' => '',
            'output' => array(
                'background-color' => '.em-quearys-top.msin-menu-search .em-quearys-menu i:hover',
                'border-color' => '.em-quearys-form:hover'
            )
        ),
        /* Social Icon Section */
        array(
            'id' => 'main_icon_hide',
            'type' => 'info',
            'title' => esc_html__('Social Color setting ************************', 'poket'),
            'desc' => esc_html__('go "social Icon section" and change color there', 'poket'),
        ),        
        /* WooCommerce Section */
        array(
            'id' => 'main_woo_hide',
            'type' => 'info',
            'title' => esc_html__('WooCommerce Color setting ************************', 'poket'),
            'desc' => esc_html__('Change WooCommerce Mini Icon color here.', 'poket'),
        ),         
        array(
            'id' => 'poket_woo_icon_color',
            'type' => 'color',
            'desc' => esc_html__('WooCommerce icon Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.mini_shop_content a i,.mini_shop_content a span.count'
            )
        ),
        array(
            'id' => 'poket_woo_ibg_color',
            'type' => 'color',
            'desc' => esc_html__('WooCommerce BG Color', 'poket'),
            'default' => '',
            'output' => array(
                'background-color' => '.mini_shop_content a i,.mini_shop_content a span.count',
            )
        ),
        /* Popup Menu Section */
        array(
            'id' => 'main_popup_hide',
            'type' => 'info',
            'title' => esc_html__('Popup Menu Icon Color setting ************************', 'poket'),
            'desc' => esc_html__('Change popup menu Icon color here', 'poket'),
        ),
        array(
            'id' => 'txt_ppicon_color',
            'type' => 'color',
            'desc' => esc_html__('Popup Menu Icon Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.right_sideber_menu i'
            )
        ),                     
        /* Login Section */
        array(
            'id' => 'mmenu_login_hide',
            'type' => 'info',
            'title' => esc_html__('Login Color setting ************************', 'poket'),
            'desc' => esc_html__('Change login text color here', 'poket'),
        ),
        array(
            'id' => 'txt_login_color',
            'type' => 'color',
            'desc' => esc_html__('Login Icon and text Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.em-login a'
            )
        ),                
        /* Phone Number Section */
        array(
            'id' => 'mmenu_its_hide',
            'type' => 'info',
            'title' => esc_html__('Phone Number Color setting ************************', 'poket'),
            'desc' => esc_html__('Change phone number text color here', 'poket'),
        ),       
        array(
            'id' => 'main_menu_icon',
            'type' => 'text',
            'title' => esc_html__('Set Icon', 'poket'),
            'desc' => esc_html__('insert icofont icon here. ex - <i class="ti-mobile"></i> go https://themify.me/themify-icons . Not use the field, remove the text from field', 'poket'),
            'default' => esc_html__('<i class="ti-mobile"></i>', 'poket'),
        ),
        array(
            'id' => 'main_menu_top_title',
            'type' => 'text',
            'title' => esc_html__('Title', 'poket'),
            'desc' => esc_html__('insert title here', 'poket'),
            'default' => esc_html__('Phone', 'poket'),
        ),
        array(
            'id' => 'main_menu_number',
            'type' => 'text',
            'title' => esc_html__('Sub Title', 'poket'),
            'desc' => esc_html__('insert sub title here', 'poket'),
            'default' => esc_html__('+998556778345', 'poket'),
        ),
        array(
            'id' => 'colorf_numberit_color',
            'type' => 'color',
            'desc' => esc_html__('Number Icon and Text Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.mcallicon i,.mcallphone p'
            )
        ),
        array(
            'id' => 'colorf_number_color',
            'type' => 'color',
            'desc' => esc_html__('Phone Number Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.mcallphone p a'
            )
        ),
  /* section menu setting */
        array(
            'id' => 'poket_menu_bg_color',
            'type' => 'background',
            'title' => esc_html__('Main Menu Section BG Color', 'poket'),
            'default' => '',
            'output' => array(
                '.poket_nav_area,.transprent-menu .poket_nav_area,.hmenu_box_style'
            ),
            'default' => array(
                'background-color' => '',
            )
        ),
        array(
            'id' => 'main_header_border',
            'type' => 'border',
            'title' => __('Section Border Option', 'poket'),
            'subtitle' => __('Only color validation can be done on this field type', 'poket'),
            'output' => array(
                '.poket_nav_area,.trp_nav_area'
            ),
            'desc' => __('This is the description field, again good for additional info.', 'poket'),
            'default' => array(
                'border-color' => '',
                'border-style' => 'solid',
                'border-top' => '',
                'border-right' => '',
                'border-bottom' => '',
                'border-left' => ''
            )
        ),
        array(
            'id' => 'menu_spacing',
            'type' => 'spacing',
            'output' => array(
                '.poket_nav_area,.trp_nav_area,.transprent-menu .poket_nav_area'
            ),
            'mode' => 'padding',
            'units' => array(
                'em',
                'px'
            ),
            'units_extended' => 'false',
            'title' => esc_html__('Section Padding Option', 'poket'),
            'subtitle' => esc_html__('Set your padding here.', 'poket'),
            'desc' => esc_html__('Top, Right, Bottom, Left', 'poket'),
            'default' => array(
                'padding-top' => '',
                'padding-right' => '',
                'padding-bottom' => '',
                'padding-left' => '',
                'units' => 'px',
            )
        ),

    ),
));

/*========================
END poket HEADER FIELD
=========================*/

/*========================
poket BREADCRUMB FIELD
=========================*/
Redux::setSection($opt_name, array(
    'title' => esc_html__('Breadcrumb Area', 'poket'),
    'id' => 'poket_bread_page',
    'icon' => 'el-icon-picture',
    'fields' => array(
        array(
            'id' => 'info_normal',
            'type' => 'info',
            'desc' => esc_html__('Notice:- If you want to more breadcrumb control. Please see every page bottom area. We Added More Field Here', 'poket')
        ),
        array(
            'id' => 'poket_breadcr_style',
            'type' => 'select',
            'title' => esc_html__('Select Breadcrumb Style', 'poket'),
            'customizer_only' => false,
            'options' => array(
                '0' => esc_html__('Select style ', 'poket'),
                '1' => esc_html__('Style 1 ', 'poket'),
                '2' => esc_html__('Style 2 ', 'poket'),
                '3' => esc_html__('Breadcrumb None ', 'poket'),
            ),
            'default' => '1'
        ),
        array(
            'id' => 'bpage_text_align',
            'type' => 'select',
            'title' => esc_html__('Breadcrumb Text Align Style', 'poket'),
            'desc' => esc_html__('this option work only, when select Breadcrumb Style 1', 'poket'),
            'customizer_only' => false,
            'options' => array(
                'text-left' => esc_html__('Align Left', 'poket'),
                'text-center' => esc_html__('Align Middle', 'poket'),
                'text-right' => esc_html__('Alige Right', 'poket'),
            ),
            'default' => 'text-center'
        ),
        array(
            'id' => 'bpage_text_transform',
            'type' => 'select',
            'title' => esc_html__('Breadcrumb Text Transform Style', 'poket'),
            'customizer_only' => false,
            'options' => array(
                'lcase' => esc_html__('Transform lowercase', 'poket'),
                'ucase' => esc_html__('Transform uppercase', 'poket'),
                'ccase' => esc_html__('Transform capitalize', 'poket'),
            ),
            'default' => 'ccase'
        ),

        array(
            'id' => 'poket_breadcrumb_bg',
            'type' => 'background',
            'output' => array(
                '.breadcumb-area,.breadcumb-blog-area'
            ),
            'title' => esc_html__('Breadcrumb Background', 'poket'),
            'subtitle' => esc_html__('Breadcrumb background with image, color.', 'poket'),
            'default' => array(
                'background-color' => '',
            )
        ),
        array(
            'id' => 'poket_brdov_text_color',
            'type' => 'color_rgba',
            'title' => esc_html__('Breadcumb Overlay', 'poket'),
            'default' => array(
                'color' => '',
                'alpha' => 1
            ),
            'options' => array(
                'show_input' => true,
                'show_initial' => true,
                'show_alpha' => true,
                'show_palette' => true,
                'show_palette_only' => false,
                'show_selection_palette' => true,
                'max_palette_size' => 10,
                'allow_empty' => true,
                'clickout_fires_change' => false,
                'choose_text' => 'Choose',
                'cancel_text' => 'Cancel',
                'show_buttons' => true,
                'use_extended_classes' => true,
                'palette' => null,
                'input_text' => 'Select Color'
            ),
            'output' => array(
                'background-color' => '
		.breadcumb-area::before,
		.breadcumb-blog-area::before
		'
            )
        ),
        array(
            'id' => 'poket_breadcumb_overlay_gr',
            'type' => 'color_gradient',
            'title' => esc_html__('Breadcumb Overlay Gradient BG Color', 'poket'),
            'desc' => esc_html__('Set Gradient From here.', 'poket'),
            'validate' => 'color',
            'default' => array(
                'from' => '',
                'to' => '',
            )
        ),
        array(
            'id' => 'poket_bread_titleh',
            'type' => 'switch',
            'title' => esc_html__('Title ON/OFF Option', 'poket'),
            'default' => false,
        ),
        array(
            'id' => 'poket_bread_title_page_color',
            'type' => 'typography',
            'title' => esc_html__('Breadcrumb Title Style', 'poket'),
            'google' => true,
            'font-backup' => true,
            'line-height' => false,
            'text-align' => false,
            'output' => array(
                '
				.brpt .brcrumb_title,.breadcumb-inner .brcrumb_title,.brpt.brptsize .brcrumb_title    
				'
            ),
            'units' => 'px',
            'subtitle' => esc_html__('Typography option with each property can be called individually.', 'poket'),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
            ),
        ),

        array(
            'id' => 'poket_bread_menuhide',
            'type' => 'switch',
            'title' => esc_html__('Breadcrumb Menu Hide Option', 'poket'),
            'desc' => esc_html__('When Set ON, Link Item Will Hide and When Set Off, Link Item Will Show', 'poket'),
            'default' => false,
        ),
        array(
            'id' => 'poket_current_position',
            'type' => 'text',
            'title' => esc_html__('Change Text Currently Here', 'poket'),
            'desc' => esc_html__('Change your You Are Currently Here text . Not use the field, remove the text from field. It will Show Default', 'poket'),
            'default' => esc_html__('You Here!', 'poket'),
        ),
        array(
            'id' => 'poket_breadhome_textc',
            'type' => 'text',
            'title' => esc_html__('Chnage text Home', 'poket'),
            'desc' => esc_html__('Change your Home Here text . Not use the field, remove the text from field. It will Show Default', 'poket'),
            'default' => esc_html__('Home', 'poket'),
        ),
        array(
            'id' => 'poket_breadbar_textc',
            'type' => 'text',
            'title' => esc_html__('Change Icon or bar', 'poket'),
            'desc' => esc_html__('insert icofont icon here. ex - <i class="ti-angle-right"></i> go https://themify.me/themify-icons . Not use the field, remove the text from field.. It will Show Default', 'poket'),
            'default' => esc_html__('-', 'poket'),
        ),
        array(
            'id' => 'poket_breadcrumb_typography',
            'type' => 'typography',
            'title' => esc_html__('Breadcrumb Text And Font style', 'poket'),
            'google' => true,
            'font-backup' => true,
            'line-height' => false,
            'text-align' => false,
            'output' => array(
                '
      .breadcumb-inner ul,     
      .breadcumb-inner ul span a,     
      .breadcumb-inner li,
      .breadcumb-inner li a,.witr_breadcumb_shop ul li span a     
     '
            ),
            'units' => 'px',
            'subtitle' => esc_html__('Typography option with each property can be called individually.', 'poket'),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
            ),
        ),
        array(
            'id' => 'poket_bread_current_page_color',
            'type' => 'color',
            'title' => esc_html__('Breadcrumb Current Text Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.breadcumb-inner ul span.current,.witr_breadcumb_shop ul li span'
            )
        ),
        array(
            'id' => 'spacing',
            'type' => 'spacing',
            'output' => array(
                '.breadcumb-area,.breadcumb-area.breadcumb_st2,.breadcumb-blog-area'
            ),
            'mode' => 'padding',
            'units' => array(
                'em',
                'px'
            ),
            'units_extended' => 'false',
            'title' => esc_html__('Padding Option', 'poket'),
            'subtitle' => esc_html__('Allow your users to choose the spacing or margin they want.', 'poket'),
            'desc' => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'poket'),
            'default' => array(
                'padding-top' => '',
                'padding-right' => '',
                'padding-bottom' => '',
                'padding-left' => '',
                'units' => 'px',
            )
        ),

    ),
));

if (class_exists('WooCommerce')) {

    Redux::setSection($opt_name, array(
        'title' => esc_html__('Shop Breadcumb', 'poket'),
        'id' => 'poket_bredshop_page',
        'icon' => 'el-icon-picture',
        'subsection' => true,
        'fields' => array(
            array(
                'id' => 'info_normshop',
                'type' => 'info',
                'desc' => esc_html__('Notice:- All breadcrumb Field working in shop area. if you want to change shop breadcrumb bg image, Please change here', 'poket')
            ),
            array(
                'id' => 'poket_shopbread_bg',
                'type' => 'background',
                'output' => array(
                    '.breadcumb-area.breadcumb_st2.msope_bgarea,.breadcumb-area.msope_bgarea'
                ),
                'title' => esc_html__('Shop Background Image', 'poket'),
                'default' => array(
                    'background-color' => '',
                )
            ),

        ),
    ));
}

/*========================
END poket BREADCRUMB FIELD
=========================*/

/*========================
poket BLOG FIELD
=========================*/
Redux::setSection($opt_name, array(
    'title' => esc_html__('Blog Area', 'poket'),
    'id' => 'poket_blog_section_area',
    'desc' => esc_html__('Blog and Single Blog Style here', 'poket'),
    'icon' => 'el el-circle-arrow-right',
    'fields' => array(
        array(
            'id' => 'poket_blog_btn_text',
            'type' => 'text',
            'title' => esc_html__('Blog Button', 'poket'),
            'desc' => esc_html__('insert button text here. Not use the Button, remove the text from field', 'poket'),
            'default' => esc_html__('Details', 'poket'),
        ),
        array(
            'id' => 'poket_blog_post_meta',
            'type' => 'switch',
            'title' => esc_html__('Blog Post Meta Hide/Show', 'poket'),
            'desc' => esc_html__('When set On, It Will Hide', 'poket'),
            'default' => false,
        ),
        array(
            'id' => 'poket_blc_hide',
            'type' => 'switch',
            'title' => esc_html__('Blog Single Social Icon Show/Hide', 'poket'),
            'default' => false,
        ),
        array(
            'id' => 'poket_blitc',
            'type' => 'background',
            'output' => array(
                '.poket_blog_item,.poket_blog_details'
            ),
            'title' => esc_html__('Blog Item BG Color', 'poket'),
            'subtitle' => esc_html__('BG color', 'poket'),
            'default' => array(
                'background-color' => '',
            )
        ),

        array(
            'id' => 'poket_bltc',
            'type' => 'color',
            'title' => esc_html__('Blog Title Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '
						.poket_blog_content h1, .poket_blog_content h2, .poket_blog_content h3, .poket_blog_content h4, .poket_blog_content h5, .poket_blog_content h6,					
						.poket_blog_details h1, .poket_blog_details h2, .poket_blog_details h3, .poket_blog_details h4, .poket_blog_details h5, .poket_blog_details h6,
						.poket_blog_content h2 a,.blog-page-title a,.poket-single-blog-title h2					
					'
            )
        ),
        array(
            'id' => 'poket_bltch',
            'type' => 'color',
            'title' => esc_html__('Blog Title Hover Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '
					.poket_blog_content h2 a:hover,
					.blog-page-title h2 a:hover,p.sticky_featured				
					',
                'border-color' => '.sticky .poket_blog_item, .tag-sticky-2 .poket_blog_item'
            )
        ),
        array(
            'id' => 'poket_bltxc',
            'type' => 'color',
            'title' => esc_html__('Blog Text Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '
					 .poket_blog_content p,
					 .poket_blog_details p,
					 .poket_blog_details ul,
					 .poket_blog_details ol,
					 .poket_blog_details address,
					 .poket_blog_details table tr th,
					 .poket_blog_details table tr td,
					 .poket_blog_details dl,
					 .poket_blog_details dd,
					 .poket_blog_details cite
					'
            )
        ),
        array(
            'id' => 'poket_blog_plink',
            'type' => 'color',
            'title' => esc_html__('Blog Link Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '
					 .poket_blog_details table tr th a,
					 .poket_blog_details table tr td a,
					 .poket_blog_details a,
					 .poket_blog_details ul a,
					 .poket_blog_details ol a					 
					'
            )
        ),
        array(
            'id' => 'poket_blpmc',
            'type' => 'color',
            'title' => esc_html__('Blog Post Meta Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '
					.poket_meta span a, .poket_meta span
					'
            )
        ),
        array(
            'id' => 'poket_blpmic',
            'type' => 'color',
            'title' => esc_html__('Blog Meta Icon Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '
					 .poket_meta i
					'
            )
        ),
        array(
            'id' => 'poket_bbltxc',
            'type' => 'color',
            'title' => esc_html__('Blog Button Text Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '
						.blog_readmore a
					'
            )
        ),
        array(
            'id' => 'poket_blog_bhctext',
            'type' => 'color',
            'title' => esc_html__('Blog Button Text Hover Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.blog_readmore a:hover'
            )
        ),
        array(
            'id' => 'poket_blog_btnbgcolor',
            'type' => 'background',
            'output' => array(
                '.blog_readmore a'
            ),
            'title' => esc_html__('Button BG Color', 'poket'),
            'default' => array(
                'background-color' => '',
            )
        ),
        array(
            'id' => 'poket_blog_bbbtnbgcolor',
            'type' => 'border',
            'output' => array(
                '.blog_readmore a'
            ),
            'title' => esc_html__('Button Border Color', 'poket'),
            'default' => '',
        ),
        array(
            'id' => 'poket_blog_bhbtnbgcolor',
            'type' => 'background',
            'output' => array(
                '.blog_readmore a:hover'
            ),
            'title' => esc_html__('Button Hover BG Color', 'poket'),
            'default' => array(
                'background-color' => '',
            )
        ),
        array(
            'id' => 'poket_blog_bbhbtnbgcolor',
            'type' => 'border',
            'output' => array(
                '.blog_readmore a:hover'
            ),
            'title' => esc_html__('Button Hover Border Color', 'poket'),
            'default' => '',
        ),

        array(
            'id' => 'poket_bstic',
            'type' => 'color',
            'title' => esc_html__('Single Blog Tag Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.poket_sblog_tag ul li a',
                'border-color' => '.poket_sblog_tag ul li a',
            )
        ),
        array(
            'id' => 'poket_bstibgc',
            'type' => 'color',
            'title' => esc_html__('Single Blog Tag BG Color', 'poket'),
            'default' => '',
            'output' => array(
                'background-color' => '.poket_sblog_tag ul li a',
                'border-color' => '.poket_sblog_tag ul li a',
            )
        ),
        array(
            'id' => 'poket_bsictc',
            'type' => 'color',
            'title' => esc_html__('Single Social Icon Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.poket-single-icon a',
                'border-color' => '.poket-single-icon a',
            )
        ),
        array(
            'id' => 'poket_blsoiclh',
            'type' => 'color',
            'title' => esc_html__('Single Blog Social Icon & Tag Hover BG Color', 'poket'),
            'default' => '',
            'output' => array(
                'background-color' => '.poket_sblog_tag ul li a:hover,.poket-single-icon a:hover',
                'border-color' => '.poket_sblog_tag ul li a:hover,.poket-single-icon a:hover',
            )
        ),
        array(
            'id' => 'poket_pgtc',
            'type' => 'color',
            'title' => esc_html__('Pagination Text Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.paginations a',
                'border-color' => '.paginations a',
            )
        ),

        array(
            'id' => 'poket_pghbgc',
            'type' => 'color',
            'title' => esc_html__('Pagination Hover BG Color', 'poket'),
            'default' => '',
            'output' => array(
                'background-color' => '.paginations .page-numbers.current, .poket-blog-area .page-numbers.current, .witr_shop_area .page-numbers.current,.tutor-pagination-wrap span.page-numbers.current,a.page-numbers:hover,.tutor-pagination-wrap a:hover',
                'border-color' => '.paginations .page-numbers.current, .poket-blog-area .page-numbers.current, .witr_shop_area .page-numbers.current,.tutor-pagination-wrap span.page-numbers.current,a.page-numbers:hover,.tutor-pagination-wrap a:hover',
            )
        ),
        array(
            'id' => 'poket_blsp',
            'type' => 'spacing',
            'output' => array(
                '.poket_blog_content'
            ),
            'mode' => 'padding',
            'units' => array(
                'em',
                'px'
            ),
            'units_extended' => 'false',
            'title' => esc_html__('Blog Item Padding Option', 'poket'),
            'subtitle' => esc_html__('Allow your users to choose the spacing or padding they want.', 'poket'),
            'desc' => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'poket'),
            'default' => array(
                'padding-top' => '',
                'padding-right' => '',
                'padding-bottom' => '',
                'padding-left' => '',
                'units' => 'px',
            )
        ),
        array(
            'id' => 'poket_blssp',
            'type' => 'spacing',
            'output' => array(
                '.poket_blog_details'
            ),
            'mode' => 'padding',
            'units' => array(
                'em',
                'px'
            ),
            'units_extended' => 'false',
            'title' => esc_html__('Single Blog Padding Option', 'poket'),
            'subtitle' => esc_html__('Allow your users to choose the spacing or padding they want.', 'poket'),
            'desc' => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'poket'),
            'default' => array(
                'padding-top' => '',
                'padding-right' => '',
                'padding-bottom' => '',
                'padding-left' => '',
                'units' => 'px',
            )
        ),
    )
));
/* blog sidebar */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Blog Sidebar', 'poket'),
    'id' => 'poket_blogsidebar_page',
    'icon' => 'el-icon-picture',
    'subsection' => true,
    'fields' => array(

        array(
            'id' => 'poket_blog_widget_bgcolor',
            'type' => 'background',
            'output' => array(
                '.poket_s_color > div'
            ),
            'title' => esc_html__('Blog Sidebar BG Color', 'poket'),
            'subtitle' => esc_html__('BG color', 'poket'),
            'default' => array(
                'background-color' => '',
            )
        ),
        array(
            'id' => 'poket_sidebar_widgett_text_color',
            'type' => 'color',
            'title' => esc_html__('Sidebar Title Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.poket_s_color .widget h2'
            )
        ),
        array(
            'id' => 'poket_blog_blockbar_hover',
            'type' => 'color',
            'title' => esc_html__('Title Block Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '
							.poket_s_color .widget.widget_block h2, .wp-block-search__label,
							.poket_s_color #wp-calendar>caption,
							.poket_s_color .wp-block-search__button
						'
            )
        ),

        array(
            'id' => 'poket_wbarst',
            'type' => 'color',
            'title' => esc_html__('Title bar and Block BG Color', 'poket'),
            'default' => '',
            'output' => array(
                'border-color' => '
					.poket_s_color .widget.widget_block h2, .wp-block-search__label,
					.poket_s_color #wp-calendar>caption,
					.poket_s_color .wp-block-search__button,.poket_s_color .widget-title::before',
                'background' => '
					.poket_s_color .widget.widget_block h2,
					.wp-block-search__label,
					.poket_s_color #wp-calendar>caption,
					.poket_s_color .wp-block-search__button
					',
            )
        ),
        array(
            'id' => 'poket_sidebar_widget_li_color',
            'type' => 'color',
            'title' => esc_html__('Sidebar Text Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '
							.poket_s_color footer,
							.poket_s_color .widget ul li,
							.poket_s_color .widget ul li a,
							.poket_s_color .widget ul li::before,
							.tagcloud a,
							caption,
							table,
							 table td a,
							cite,
							.rssSummary,
							span.rss-date,
							span.comment-author-link,
							.textwidget p,
							.widget .screen-reader-text,
							.poket_s_color .widget a,
							.poket_s_color .widget p,
							.poket_s_color .widget .tagcloud a,
							.widget.widget_categories select
						'
            )
        ),
        array(
            'id' => 'poket_sidebar_widget_li_hover_color',
            'type' => 'color',
            'title' => esc_html__('Sidebar Text Hover Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '
							.poket_s_color .widget ul li a:hover,
							.poket_s_color .widget ul li:hover::before,
							.poket_s_color .widget a:hover,
							.poket_s_color .widget .tagcloud a:hover,
							.poket_s_color .widget .wp-block-archives li:hover::before, .poket_s_color .widget .wp-block-categories li:hover::before
						'
            )
        ),
        array(
            'id' => 'poket_blog_link',
            'type' => 'color',
            'title' => esc_html__('Blog Link Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '
							.poket_s_color .widget a				
						',
                'background-color' => '
							.poket_s_color #wp-calendar th				
						'
            )
        ),
        array(
            'id' => 'poket_blog_link_hover',
            'type' => 'color',
            'title' => esc_html__('Blog Link Hover Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '
							.poket_s_color .widget a:hover
						'
            )
        ),

    ),
));

/*========================
END poket BLOG FIELD
=========================*/

/*========================
poket 404 FIELD
=========================*/

Redux::setSection($opt_name, array(
    'title' => esc_html__('404 Area', 'poket'),
    'id' => 'poket_error_page',
    'desc' => esc_html__('Use this section to upload background images, select background color', 'poket'),
    'icon' => 'el-icon-cog',
    'fields' => array(
        array(
            'id' => 'poket_background_404',
            'type' => 'background',
            'output' => array(
                '.not-found-area'
            ),
            'title' => esc_html__('404 Page Background Color', 'poket'),
            'subtitle' => esc_html__('404 background with image, color.', 'poket'),
            'default' => array(
                'background-color' => '',
            )
        ),
        array(
            'id' => 'poket_not_title',
            'type' => 'color',
            'title' => esc_html__('Title Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.not-found-inner h2,.not-found-inner'
            )
        ),
        array(
            'id' => 'poket_sub_not_title',
            'type' => 'color',
            'title' => esc_html__('Sub Title Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.not-found-inner p,.not-found-inner strong'
            )
        ),
        array(
            'id' => 'poket_not_link_color',
            'type' => 'color',
            'title' => esc_html__('Return Link Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.not-found-inner a'
            )
        ),
        array(
            'id' => '404_info',
            'type' => 'editor',
            'title' => esc_html__('404 Information', 'poket'),
            'subtitle' => esc_html__('HTML tags allowed: a, br, em, strong', 'poket'),
            'default' => esc_html__('404 Oops! The page you are Looking for does not exist. ', 'poket'),
            'desc' => esc_html__('Please use title this way. example- <h2>404</h2> and text <p>your text</p>', 'poket'),
        ),
        array(
            'id' => 'poket_notfound_spacing',
            'type' => 'spacing',
            'output' => array(
                '.not-found-area'
            ),
            'mode' => 'padding',
            'units' => array(
                'em',
                'px'
            ),
            'units_extended' => 'false',
            'title' => esc_html__('Section Padding Option', 'poket'),
            'subtitle' => esc_html__('Allow your users to choose the spacing or padding they want.', 'poket'),
            'desc' => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'poket'),
            'default' => array(
                'padding-top' => '',
                'padding-right' => '',
                'padding-bottom' => '',
                'padding-left' => '',
                'units' => 'px',
            )
        ),

    ),
));

/*========================
END poket NOT FOUND FIELD
=========================*/

/*========================
poket Scroll Up
=========================*/

Redux::setSection($opt_name, array(
    'title' => esc_html__('ScrollUp Area', 'poket'),
    'id' => 'poket_scrollup_page',
    'desc' => esc_html__('Use this section to upload background images, select background color', 'poket'),
    'icon' => 'el-icon-cog',
    'fields' => array(

        array(
            'id' => 'poket_scrollup_color',
            'type' => 'color',
            'title' => esc_html__('Icon Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '#scrollUp i'
            )
        ),
        array(
            'id' => 'poket_background_scrollup',
            'type' => 'background',
            'output' => array(
                '#scrollUp'
            ),
            'title' => esc_html__('Icon Background Color', 'poket'),
            'subtitle' => esc_html__('Icon background with image, color.', 'poket'),
            'default' => array(
                'background-color' => '',
            )
        ),

        array(
            'id' => 'poket_scrollup_height_widget',
            'type' => 'dimensions',
            'units' => array(
                'em',
                'px',
                '%'
            ),
            'output' => array(
                '#scrollUp'
            ),
            'title' => esc_html__('Icon (Width/Height) Option', 'poket'),
            'subtitle' => esc_html__('Allow your users to choose width, height, and/or unit.', 'poket'),
            'desc' => esc_html__('Enable or disable any piece of this field. Width, Height, or Units.', 'poket'),
            'default' => '',
        ),

        /*array(
                    'id'        => 'poket_scrollup_line_height',
                    'type'      => 'text',
        'output'    => array('#scrollUp'),
                    'title'     => esc_html__('Icon Line Height ', 'poket'),
                    'mode'      => false,
                    'desc'      => esc_html__('Set number default-40px', 'poket'),
        'default'   =>'',
                ),*/

    ),
));

/*========================
END poket NOT FOUND FIELD
=========================*/

/*========================
poket Shop FIELD
=========================*/
if (class_exists('WooCommerce')) {

    Redux::setSection($opt_name, array(
        'title' => esc_html__('Shop Area', 'poket'),
        'id' => 'poket_woocom_page',
        'desc' => esc_html__('Set your shop style option here', 'poket'),
        'icon' => 'el-icon-cog',
        'fields' => array(
            array(
                'id' => 'poket_shopsb',
                'type' => 'select',
                'title' => esc_html__('Shop Style', 'poket'),
                'default' => '1',
                'options' => array(
                    '1' => esc_html__('Shop Left & Right Sidebar', 'poket'),
                    '2' => esc_html__('Shop Right & Left Sidebar', 'poket'),
                    '3' => esc_html__('Shop & No Sidebar', 'poket')
                )
            ),

            array(
                'id' => 'poket_shop_related',
                'type' => 'switch',
                'title' => esc_html__('Shop Relate Product ON/OFF Option', 'poket'),
                'default' => true,
            ),
            /* Title And Price box color area */
            array(
                'id' => 'poket_woocommerce_count',
                'type' => 'color',
                'title' => esc_html__('Showing Count Color', 'poket'),
                'default' => '',
                'output' => array(
                    'color' => '.woocommerce .woocommerce-result-count, .nice-select span.current,.nice-select .option'
                )
            ),

            array(
                'id' => 'poket_background_woocommerce',
                'type' => 'background',
                'output' => array(
                    '.tbd_product_content'
                ),
                'title' => esc_html__('Background Color', 'poket'),
                'subtitle' => esc_html__('background, color.', 'poket'),
                'default' => array(
                    'background-color' => '',
                )
            ),
            array(
                'id' => 'poket_woocommerce_title',
                'type' => 'color',
                'title' => esc_html__('Title Color', 'poket'),
                'default' => '',
                'output' => array(
                    'color' => '.tbd_product_title h2,.woocommerce div.product .product_title,.tbd_product_title h3,.woocommerce .twr_product_sidebar ul.product_list_widget li a'
                )
            ),
            array(
                'id' => 'poket_woocommerce_htitle',
                'type' => 'color',
                'title' => esc_html__('Title Hover Color', 'poket'),
                'default' => '',
                'output' => array(
                    'color' => '.tbd_product_title h2:hover,.woocommerce div.product .product_title:hover,.tbd_product_title h3:hover,.woocommerce .twr_product_sidebar ul.product_list_widget li a:hover'
                )
            ),
            array(
                'id' => 'poket_price_woocommerce',
                'type' => 'color',
                'title' => esc_html__('Price Color', 'poket'),
                'default' => '',
                'output' => array(
                    'color' => '.woocommerce div.product p.price, .woocommerce div.product span.price, .woocommerce div.product p.price, .woocommerce div.product span.price, .woocommerce div.product p.price ins, .woocommerce div.product span.price ins,.woocommerce div.product .stock,.woocommerce .twr_product_sidebar span.woocommerce-Price-amount.amount'
                )
            ),
            array(
                'id' => 'poket_price_star_color',
                'type' => 'color',
                'title' => esc_html__('Rating Color', 'poket'),
                'default' => '',
                'output' => array(
                    'color' => '.woocommerce .products .star-rating, .woocommerce .star-rating'
                )
            ),
            array(
                'id' => 'poket_product_iconc',
                'type' => 'color',
                'title' => esc_html__('Product Icon Color', 'poket'),
                'default' => '',
                'output' => array(
                    'color' => '.tbd_product .thb_product_car a'
                )
            ),
            array(
                'id' => 'poket_product_iconch',
                'type' => 'color',
                'title' => esc_html__('Product Icon Hover Color', 'poket'),
                'default' => '',
                'output' => array(
                    'color' => '.tbd_product .thb_product_car a:hover,.thb_product_car a.added_to_cart:hover:before'
                )
            ),
            array(
                'id' => 'poket_product_iconc_bg',
                'type' => 'color',
                'title' => esc_html__('Product Icon BG Color', 'poket'),
                'default' => '',
                'output' => array(
                    'background-color' => '.tbd_product .thb_product_car a',
                    'border-color' => '.tbd_product .thb_product_car a'

                )
            ),
            array(
                'id' => 'poket_product_iconc_hbg',
                'type' => 'color',
                'title' => esc_html__('Product Icon BG Hover Color', 'poket'),
                'default' => '',
                'output' => array(
                    'background-color' => '.tbd_product .thb_product_car a:hover,.thb_product_car a.added_to_cart:hover:before,.twr_product_sidebar .tagcloud a:hover,.widget_product_search button',
                    'border-color' => '.tbd_product .thb_product_car a:hover,.thb_product_car a.added_to_cart:hover:before,.twr_product_sidebar .tagcloud a:hover,.widget_product_search button,'

                )
            ),

            array(
                'id' => 'poket_Button_color_wooco',
                'type' => 'color',
                'title' => esc_html__('Button Text Color', 'poket'),
                'default' => '',
                'output' => array(
                    'color' => '.woocommerce .witr_product_cart button.button:disabled, .woocommerce .witr_product_cart button.button:disabled[disabled], .woocommerce .witr_cart_to_cross a.checkout-button.alt, .woocommerce .witr_checkout_form button.button.alt, .woocommerce a.button.wc-backward, .woocommerce input.button,.woocommerce div.product form.cart .button,.woocommerce div.product .woocommerce-tabs ul.tabs li.active a,.poket_btn,.witr_cart_to_cross .cart_totals > h2,.witr_checkout_form .witr_ck_blling h3, .witr_checkout_form h3#order_review_heading, h2.woocommerce-order-details__title,.woocommerce-column__title,nav.woocommerce-MyAccount-navigation ul li.is-active,
					ul.tx_product_tab.nav li a'
                )
            ),
            array(
                'id' => 'poket_Buttonht_woocommerce',
                'type' => 'color',
                'title' => esc_html__('Button Text Hover Color', 'poket'),
                'default' => '',
                'output' => array(
                    'color' => '.woocommerce .witr_cart_to_cross a.checkout-button.alt:hover,.woocommerce a.button.wc-backward:hover, .woocommerce .witr_checkout_form button.button.alt:hover, .woocommerce input.button:hover,.woocommerce div.product form.cart .button,.poket_btn:hover,.paginations a:hover, .paginations a.current, .page-numbers span.current'
                )
            ),
            array(
                'id' => 'poket_Button_bgw',
                'type' => 'color',
                'title' => esc_html__('Button BG Color', 'poket'),
                'default' => '',
                'output' => array(
                    'background-color' => '.woocommerce .witr_product_cart button.button:disabled, .woocommerce .witr_product_cart button.button:disabled[disabled],  .woocommerce .witr_cart_to_cross a.checkout-button.alt, .woocommerce .witr_checkout_form button.button.alt, .woocommerce a.button.wc-backward,  .woocommerce input.button,.woocommerce div.product form.cart .button,.woocommerce div.product .woocommerce-tabs ul.tabs li.active,,.witr_cart_to_cross .cart_totals > h2,.witr_checkout_form .witr_ck_blling h3, .witr_checkout_form h3#order_review_heading, h2.woocommerce-order-details__title,.woocommerce-column__title,nav.woocommerce-MyAccount-navigation ul li.is-active',

                    'border-left-color' => 'nav.woocommerce-MyAccount-navigation ul li.is-active:after',
                    'border-color' => '.woocommerce .witr_product_cart button.button:disabled, .woocommerce .witr_product_cart button.button:disabled[disabled],.woocommerce .witr_cart_to_cross a.checkout-button.alt, .woocommerce .witr_checkout_form button.button.alt, .woocommerce a.button.wc-backward, .woocommerce input.button,.woocommerce div.product form.cart .button,.poket_btn,.witr_cart_to_cross .cart_totals > h2,.witr_checkout_form .witr_ck_blling h3, .witr_checkout_form h3#order_review_heading, h2.woocommerce-order-details__title,.woocommerce-column__title,nav.woocommerce-MyAccount-navigation ul li.is-active',

                )
            ),

            array(
                'id' => 'poket_Buttonhtb_bgwh',
                'type' => 'color',
                'title' => esc_html__('Button Hover & Grid BG Color', 'poket'),
                'default' => '',
                'output' => array(
                    'background-color' => '.woocommerce .witr_cart_to_cross a.checkout-button.alt:hover, .woocommerce a.button.wc-backward:hover, .woocommerce .witr_checkout_form button.button.alt:hover, .woocommerce input.button:hover,.woocommerce div.product form.cart .button,.poket_btn:hover,ul.tx_product_tab.nav li a.active,.paginations a:hover,.paginations a.current, .page-numbers span.current',

                    'border-color' => '.woocommerce .witr_cart_to_cross a.checkout-button.alt:hover, .woocommerce a.button.wc-backward:hover, .woocommerce .witr_checkout_form button.button.alt:hover, .woocommerce input.button:hover,.woocommerce div.product form.cart .button,.poket_btn:hover,ul.tx_product_tab.nav li a.active,.paginations a:hover, .paginations a.current, .page-numbers span.current'

                )
            ),

            array(
                'id' => 'poket_Button_color_sale',
                'type' => 'color',
                'title' => esc_html__('Sale Button Text Color', 'poket'),
                'default' => '',
                'output' => array(
                    'color' => '.woocommerce span.tbd_sale_inner,.woocommerce span.onsale.onsingle_sale.tbd_sale_inner '
                )
            ),
            array(
                'id' => 'poket_Button_bgsale',
                'type' => 'color',
                'title' => esc_html__('Sale Button BG Color', 'poket'),
                'default' => '',
                'output' => array(
                    'background-color' => '.woocommerce span.tbd_sale_inner,.woocommerce span.onsale.onsingle_sale.tbd_sale_inner',
                    'border-color' => '.woocommerce span.tbd_sale_inner,.woocommerce span.onsale.onsingle_sale.tbd_sale_inner'
                )
            ),
            array(
                'id' => 'poket_swoocommerce_title',
                'type' => 'color',
                'title' => esc_html__('Sidebar Title Color', 'poket'),
                'default' => '',
                'output' => array(
                    'color' => '.twr_product_sidebar h2.widget-title'
                )
            ),
            array(
                'id' => 'poket_swoocommerce_bgtitle',
                'type' => 'color',
                'title' => esc_html__('Sidebar Title BG Color', 'poket'),
                'default' => '',
                'output' => array(
                    'background-color' => '.twr_product_sidebar h2.widget-title'
                )
            ),
            array(
                'id' => 'poket_swoocommerce_textc',
                'type' => 'color',
                'title' => esc_html__('Sidebar Text Color', 'poket'),
                'default' => '',
                'output' => array(
                    'color' => '.woocommerce .twr_product_sidebar li a,.woocommerce .twr_product_sidebar li span.count,.twr_product_sidebar p,.twr_product_sidebar .tagcloud a'
                )
            ),
            array(
                'id' => 'poket_swoocommerce_barc',
                'type' => 'color',
                'title' => esc_html__('Price Filter Bar color', 'poket'),
                'default' => '',
                'output' => array(
                    'background-color' => '.woocommerce .widget_price_filter .price_slider_amount .button,.content-widget .widget_price_filter .ui-slider .ui-slider-range,.woocommerce .widget_price_filter .price_slider_amount .button'
                )
            ),
            array(
                'id' => 'poket_swoocommerce_rangc',
                'type' => 'color',
                'title' => esc_html__('Price Filter Rang Circle color', 'poket'),
                'default' => '',
                'output' => array(
                    'background-color' => '.content-widget .widget_price_filter .ui-slider .ui-slider-handle, .content-widget .widget_price_filter .ui-slider .ui-slider-handle'
                )
            ),
            array(
                'id' => 'poket_swoocommerce_fpricec',
                'type' => 'color',
                'title' => esc_html__('Sidebar Filter Price color', 'poket'),
                'default' => '',
                'output' => array(
                    'color' => '.woocommerce .twr_product_sidebar .price_label'
                )
            ),
            array(
                'id' => 'poket_swoocommerce_bgcolor',
                'type' => 'color',
                'title' => esc_html__('Sidebar BG Color', 'poket'),
                'default' => '',
                'output' => array(
                    'background-color' => '.twr_product_sidebar > div'
                )
            ),
            array(
                'id' => 'w_sectionshop_spacing',
                'type' => 'spacing',
                'output' => array(
                    '.sec_padding'
                ),
                'mode' => 'padding',
                'units' => array(
                    'em',
                    'px'
                ),
                'units_extended' => 'false',
                'title' => esc_html__('Section Shop Area Padding Option', 'poket'),
                'desc' => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'poket'),
                'default' => array(
                    'padding-top' => '',
                    'padding-right' => '',
                    'padding-bottom' => '',
                    'padding-left' => '',
                    'units' => 'px',
                )
            ),

        ),
    ));
}
/*========================
END poket Shop FIELD
=========================*/
/*========================
poket social FIELD
=========================*/
Redux::setSection($opt_name, array(
    'title' => esc_html__(' Social Icon Section', 'poket'),
    'id' => 'poket_social_icons_sec',
    'icon' => 'el-icon-cog',
    'fields' => array(

        /* array(
        'id'       => 'tx_opt_checkbox',
        'type'     => 'checkbox',
        'title'    => __('Open A New Windows', 'poket'), 
        'desc'     => __('This is the description field', 'poket'),
        'default'  => 'target="_blank"'
    ),*/



        array(
            'id' => 'poket_social_icons',
            'type' => 'sortable',
            'title' => esc_html__('Insert Social Icons', 'poket'),
            'subtitle' => esc_html__('Enter social links', 'poket'),
            'desc' => esc_html__('Drag/drop to re-arrange', 'poket'),
            'mode' => 'text',
            'label' => true,
            'options' => array(
                'facebook' => '',
                'x fa-brands fa-x-twitters' => '',
                'instagram' => '',
                'dropbox' => '',
                'skype' => '',
                'github' => '',
                'tumblr' => '',
                'pinterest' => '',
                'google' => '',
                'linkedin' => '',
                'dribbble' => '',
                'youtube' => '',
                'vimeo' => '',
                'apple' => '',

            ),
            'default' => array(
                'facebook' => esc_url('#'),
                'x fa-brands fa-x-twitters' => esc_url('#'),
                'instagram' => esc_url('#'),

            ),
        ),


    )
));

/*=== Body Social ===*/
Redux::setSection($opt_name, array(
    'title' => esc_html__('Body Social Icon Color', 'poket'),
    'id' => 'tx_social_icons_body',
    'icon' => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields' => array(
        array(
            'id' => 'poket_header_display_social_hide',
            'desc' => esc_html__('Body Social icon OFF/ON section', 'poket'),
            'type' => 'switch',
            'title' => esc_html__('Body Social ON/OFF', 'poket'),
            'default' => false,
        ),

        array(
            'id' => 'tx_body_icon_color',
            'type' => 'color',
            'title' => esc_html__(' Icon Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.em_slider_social a',
            )
        ),
        array(
            'id' => 'tx_body_icon_bgcolor',
            'type' => 'color',
            'title' => esc_html__(' Icon BG Color', 'poket'),
            'default' => '',
            'output' => array(
                'border-color' => '.em_slider_social a',
                'background-color' => '.em_slider_social a',
            )
        ),
        array(
            'id' => 'tx_body_icon_hcolor',
            'type' => 'color',
            'title' => esc_html__(' Icon Hover Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.em_slider_social a:hover',
            )
        ),
        array(
            'id' => 'tx_body_icon_hbgcolor',
            'type' => 'color',
            'title' => esc_html__(' Icon BG Hover Color', 'poket'),
            'default' => '',
            'output' => array(
                'border-color' => '.em_slider_social a:hover',
                'background-color' => '.em_slider_social a:hover',
            )
        ),

    )
));

/*=== Top Social ===*/
Redux::setSection($opt_name, array(
    'title' => esc_html__('Top Social Icon Color', 'poket'),
    'id' => 'tx_social_icons_top',
    'icon' => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields' => array(
        array(
            'id' => 'tx_top_icon_color',
            'type' => 'color',
            'title' => esc_html__(' Icon Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.top-right-menu .social-icons li a,.top_crmenu_i_list li a i',
            )
        ),
        array(
            'id' => 'tx_top_icon_bgcolor',
            'type' => 'color',
            'title' => esc_html__(' Icon BG Color', 'poket'),
            'default' => '',
            'output' => array(
                'border-color' => '.top-right-menu .social-icons li a,.top_crmenu_i_list li a i',
                'background-color' => '.top-right-menu .social-icons li a,.top_crmenu_i_list li a i',
            )
        ),
        array(
            'id' => 'tx_top_icon_hcolor',
            'type' => 'color',
            'title' => esc_html__(' Icon Hover Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.top-right-menu .social-icons li a:hover,.top_crmenu_i_list li a i:hover',
            )
        ),
        array(
            'id' => 'tx_top_icon_hbgcolor',
            'type' => 'color',
            'title' => esc_html__(' Icon BG Hover Color', 'poket'),
            'default' => '',
            'output' => array(
                'border-color' => '.top-right-menu .social-icons li a:hover,.top_crmenu_i_list li a i:hover',
                'background-color' => '.top-right-menu .social-icons li a:hover,.top_crmenu_i_list li a i:hover',
            )
        ),

    )
));
/*=== Main Menu Social ===*/
Redux::setSection($opt_name, array(
    'title' => esc_html__('Main Menu Social Icon Color', 'poket'),
    'id' => 'tx_social_icons_mmenu',
    'icon' => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields' => array(
        array(
            'id' => 'tx_mmenu_icon_color',
            'type' => 'color',
            'title' => esc_html__(' Icon Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.p_menu_social a',
            )
        ),
        array(
            'id' => 'tx_mmenu_icon_bgcolor',
            'type' => 'color',
            'title' => esc_html__(' Icon BG Color', 'poket'),
            'default' => '',
            'output' => array(
                'border-color' => '.p_menu_social a',
                'background-color' => '.p_menu_social a',
            )
        ),
        array(
            'id' => 'tx_mmenu_icon_hcolor',
            'type' => 'color',
            'title' => esc_html__(' Icon Hover Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.p_menu_social a:hover',
            )
        ),
        array(
            'id' => 'tx_mmenu_icon_hbgcolor',
            'type' => 'color',
            'title' => esc_html__(' Icon BG Hover Color', 'poket'),
            'default' => '',
            'output' => array(
                'border-color' => '.p_menu_social a:hover',
                'background-color' => '.p_menu_social a:hover',
            )
        ),

    )
));

/*=== Footer Social ===*/
Redux::setSection($opt_name, array(
    'title' => esc_html__('Footer Social Icon Color', 'poket'),
    'id' => 'tx_social_icons_footer',
    'icon' => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields' => array(
        array(
            'id' => 'tx_footer_icon_color',
            'type' => 'color',
            'title' => esc_html__(' Icon Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.poket-description-area .social-icons a',
            )
        ),
        array(
            'id' => 'tx_footer_icon_bgcolor',
            'type' => 'color',
            'title' => esc_html__(' Icon BG Color', 'poket'),
            'default' => '',
            'output' => array(
                'border-color' => '.poket-description-area .social-icons a',
                'background-color' => '.poket-description-area .social-icons a',
            )
        ),
        array(
            'id' => 'tx_footer_icon_hcolor',
            'type' => 'color',
            'title' => esc_html__(' Icon hover Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.poket-description-area .social-icons a:hover',
            )
        ),
        array(
            'id' => 'tx_footer_icon_hbgcolor',
            'type' => 'color',
            'title' => esc_html__(' Icon BG Hover Color', 'poket'),
            'default' => '',
            'output' => array(
                'border-color' => '.poket-description-area .social-icons a:hover',
                'background-color' => '.poket-description-area .social-icons a:hover',
            )
        ),

    )
));








/*========================
poket FOOTER FIELD
=========================*/

/*Footer area*/
Redux::setSection($opt_name, array(
    'title' => esc_html__('Footer Area', 'poket'),
    'id' => 'footer_area_id',
    'desc' => esc_html__('Insert style for top address area', 'poket'),
    'icon' => 'el-icon-cog',
    'fields' => array(
        array(
            'id' => 'witr_show_hide_shortcode',
            'type' => 'switch',
            'title' => esc_html__('Footer subscribe Section Show/Hide', 'poket'),
            'default' => false,
        ),
        array(
            'id' => 'poket_address_hide',
            'type' => 'switch',
            'title' => esc_html__('Footer Address Section Show/Hide', 'poket'),
            'default' => false,
        ),

        array(
            'id' => 'poket_social_hide',
            'type' => 'switch',
            'title' => esc_html__('Footer Logo Section Show/Hide', 'poket'),
            'default' => false,
        ),
        array(
            'id' => 'poket_widget_hide',
            'type' => 'switch',
            'title' => esc_html__('Widget Section Hide/show', 'poket'),
            'default' => false,
        ),
        array(
            'id' => 'poket_copyright_hide',
            'type' => 'switch',
            'title' => esc_html__('Copyright Section Show/Hide', 'poket'),
            'default' => false,
        ),
        array(
            'id' => 'poket_dfaultwidget_hide',
            'type' => 'switch',
            'title' => esc_html__('Defult Widget Hide', 'poket'),
            'desc' => esc_html__('Not set on, it show default widget', 'poket'),
            'default' => false,
        ),

        array(
            'id' => 'poket_footer_box_layout',
            'type' => 'select',
            'title' => esc_html__('Select Footer layout', 'poket'),
            'customizer_only' => false,
            'options' => array(
                'footer_box' => esc_html__('Box Layout', 'poket'),
                'footer_full' => esc_html__('Full Layout', 'poket'),
            ),
            'default' => 'footer_box'
        ),

    )
));

/*========================
poket footer Section subscribe
=========================*/

Redux::setSection($opt_name, array(
    'title' => esc_html__('Footer subscribe Section', 'poket'),
    'id' => 'poket_shortcode',
    'desc' => esc_html__('This section for Title, Content, Shortcode And color Option', 'poket'),
    'icon' => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields' => array(
        array(
            'title' => esc_html__('Title Text', 'poket'),
            'subtitle' => esc_html__('HTML tags allowed: br,span', 'poket'),
            'id' => 'witr_title_shortcode',
            'default' => 'Add your title here',
            'type' => 'text',
            'desc' => esc_html__('Please use this way Example ex-<span>Add your text here</span>, <a href="#">text</a>, </br>', 'poket'),
        ),
        array(
            'id' => 'witr_content_shortcode',
            'type' => 'textarea',
            'title' => esc_html__('Content Text', 'poket'),
            'subtitle' => esc_html__('HTML tags allowed: a, br, em, strong,span,b', 'poket'),
            'default' => esc_html__('Lorem ipsum dolor sit met conjectural ', 'poket'),
            'desc' => esc_html__('Please use this way Example ex-<span>text</span>, <a href="#">text</a>, <strong>text</strong>, <em>text</em>, <b>text</b>, </br>', 'poket'),
        ),

        /* Shortcode */
        array(
            'title' => esc_html__('Shortcode option', 'poket'),
            'subtitle' => esc_html__('Add your shortcode here.', 'poket'),
            'id' => 'witr_footre_shortcode',
            'type' => 'text',
            'desc' => esc_html__('Please use shortcode this way Example ex-[mc4wp_form id="831"]', 'poket'),
        ),

        array(
            'id' => 'poket_shortcode_color',
            'type' => 'typography',
            'title' => esc_html__('Title Typography', 'poket'),
            'google' => true,
            'font-backup' => true,
            'line-height' => false,
            'text-align' => false,
            'units' => 'px',
            'subtitle' => esc_html__('Typography option with each property can be called individually.', 'poket'),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
            ),
            'output' => array(
                '
				  .shortcode_content h2'
            ),
        ),
        array(
            'id' => 'poket_shortcode_hover_color',
            'type' => 'color',
            'title' => esc_html__('Title Hover Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.shortcode_content h2:hover'
            )
        ),

        array(
            'id' => 'poket_short_typo_content',
            'type' => 'typography',
            'title' => esc_html__('Content Typography', 'poket'),
            'google' => true,
            'font-backup' => true,
            'line-height' => false,
            'text-align' => false,
            'units' => 'px',
            'subtitle' => esc_html__('Typography option with each property can be called individually.', 'poket'),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
            ),
            'output' => array(
                '
				  .shortcode_content p'
            ),
        ),

        array(
            'id' => 'poket_shortcode_form_margin',
            'type' => 'spacing',
            'output' => array(
                '.witr_shortcode_form'
            ),
            'mode' => 'margin',
            'units' => array(
                'em',
                'px'
            ),
            'units_extended' => 'false',
            'title' => esc_html__(' shortcode Form Margin', 'poket'),
            'subtitle' => esc_html__('Allow your users to choose the spacing margin they want.', 'poket'),
            'desc' => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'poket'),
            'default' => array(
                'margin-top' => '',
                'margin-right' => '',
                'margin-bottom' => '',
                'margin-left' => '',
                'units' => 'px',
            )
        ),
        array(
            'id' => 'poket_shortcode_bg_color',
            'type' => 'background',
            'title' => esc_html__(' Section BG Color', 'poket'),
            'default' => '',
            'output' => array(
                '
					.witr_shortcode_inner'
            ),
            'default' => array(
                'background-color' => '',
            )
        ),
        array(
            'id' => 'poket_shortcode_section_spacing',
            'type' => 'spacing',
            'output' => array(
                '.witr_shortcode_inner'
            ),
            'mode' => 'padding',
            'units' => array(
                'em',
                'px'
            ),
            'units_extended' => 'false',
            'title' => esc_html__(' Box Padding Option', 'poket'),
            'subtitle' => esc_html__('Allow your users to choose the spacing padding they want.', 'poket'),
            'desc' => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'poket'),
            'default' => array(
                'padding-top' => '',
                'padding-right' => '',
                'padding-bottom' => '',
                'padding-left' => '',
                'units' => 'px',
            )
        ),
        array(
            'id' => 'poket_shortcode_section_margin',
            'type' => 'spacing',
            'output' => array(
                '.witr_shortcode_inner'
            ),
            'mode' => 'margin',
            'units' => array(
                'em',
                'px'
            ),
            'units_extended' => 'false',
            'title' => esc_html__(' Box Margin Option', 'poket'),
            'subtitle' => esc_html__('Allow your users to choose the spacing margin they want.', 'poket'),
            'desc' => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'poket'),
            'default' => array(
                'margin-top' => '',
                'margin-right' => '',
                'margin-bottom' => '',
                'margin-left' => '',
                'units' => 'px',
            )
        ),

    ),
));

/* footer Address Section */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Footer Address Section', 'poket'),
    'id' => 'poket_address_section',
    'subsection' => true,
    'icon' => 'el el-circle-arrow-right',
    'fields' => array(

        array(
            'id' => 'poket_address_logo_style',
            'type' => 'select',
            'title' => esc_html__('Select Logo Style', 'poket'),
            'customizer_only' => false,
            'options' => array(
                's_logo_s1' => esc_html__('Show Text Logo', 'poket'),
                's_logo_s2' => esc_html__('Show Image Logo', 'poket'),
            ),
            'default' => 's_logo_s1'
        ),

        array(
            'id' => 'poket_address_title_text',
            'type' => 'text',
            'title' => esc_html__('Address Title Text Logo', 'poket'),
            'default' => esc_html__('poket', 'poket'),
            'desc' => esc_html__('Please set this way for different color. ex-  A<span>S</span>T<span>U</span>T<span>E</span>', 'poket'),
        ),
        array(
            'id' => 'poket_address_logo',
            'type' => 'media',
            'title' => esc_html__('Address Image Logo', 'poket'),
            'compiler' => 'true',
            'mode' => false,
            'desc' => esc_html__('Upload logo here. recommend size:- 220x50px. Notice:- If you upload this logo, Title text logo will be hide ', 'poket'),
        ),
        array(
            'id' => 'poket_address_road',
            'type' => 'text',
            'title' => esc_html__('Address Area Name', 'poket'),
            'desc' => esc_html__('insert area name ex:- house, road-4.', 'poket'),
            'default' => esc_html__('1st Floor New World Tower Rang.', 'poket'),
        ),
        array(
            'id' => 'poket_address_email',
            'type' => 'text',
            'title' => esc_html__('Email Number', 'poket'),
            'desc' => esc_html__('Insert email number', 'poket'),
            'default' => esc_html__('demo@example.com', 'poket'),
        ),
        array(
            'id' => 'poket_address_mobile',
            'type' => 'text',
            'title' => esc_html__('Phone Number', 'poket'),
            'desc' => esc_html__('Insert phone number', 'poket'),
            'default' => esc_html__('+998 556 778 345', 'poket'),
        ),
        array(
            'id' => 'poket_address_title_text_color',
            'type' => 'color',
            'title' => esc_html__('Address Title Text Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.footer-top-address h2'
            )
        ),
        array(
            'id' => 'poket_address_title2_text_color',
            'type' => 'color',
            'title' => esc_html__('Address Title Text Color 2', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.footer-top-address h2 span'
            )
        ),
        array(
            'id' => 'poket_address_text_color',
            'type' => 'color',
            'title' => esc_html__('Address Text Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.top_address_content a,.top_address_content span'
            )
        ),
        array(
            'id' => 'poket_address_bg_color',
            'type' => 'background',
            'title' => esc_html__('Address Section BG Color', 'poket'),
            'default' => '',
            'output' => array(
                '
						.top-address-area
					'
            ),
            'default' => array(
                'background-color' => '',
            )
        ),
        array(
            'id' => 'poket_address_section_spacing',
            'type' => 'spacing',
            'output' => array(
                '.top-address-area'
            ),
            'mode' => 'padding',
            'units' => array(
                'em',
                'px'
            ),
            'units_extended' => 'false',
            'title' => esc_html__('Padding Option', 'poket'),
            'subtitle' => esc_html__('Allow your users to choose the spacing padding they want.', 'poket'),
            'desc' => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'poket'),
            'default' => array(
                'padding-top' => '',
                'padding-right' => '',
                'padding-bottom' => '',
                'padding-left' => '',
                'units' => 'px',
            )
        ),
    )
));
/* footer logo section */
Redux::setSection($opt_name, array(
    'title' => esc_html__(' Footer Logo Section', 'poket'),
    'id' => 'poket_social_section',
    'icon' => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields' => array(
        array(
            'id' => 'poket_social_logo_style',
            'type' => 'select',
            'title' => esc_html__('Select Logo Style', 'poket'),
            'customizer_only' => false,
            'options' => array(
                's_logo_s1' => esc_html__('Show Text Logo', 'poket'),
                's_logo_s2' => esc_html__('Show Image Logo', 'poket'),
            ),
            'default' => 's_logo_s1'
        ),

        array(
            'id' => 'poket_social_title_text',
            'type' => 'text',
            'title' => esc_html__('Footer Title Text Logo', 'poket'),
            'default' => esc_html__('poket', 'poket'),
            'desc' => esc_html__('Please set this way for different color. ex-  A<span>S</span>T<span>U</span>T<span>E</span>', 'poket'),
        ),
        array(
            'id' => 'poket_social_logo',
            'type' => 'media',
            'title' => esc_html__('Footer Image Logo', 'poket'),
            'compiler' => 'true',
            'mode' => false,
            'desc' => esc_html__('Upload logo here. recommend size:- 220x50px. Notice:- If you upload this logo, Title text logo will be hide ', 'poket'),
        ),
        array(
            'id' => 'poket_social_text',
            'type' => 'editor',
            'title' => esc_html__('Footer logo information', 'poket'),
            'default' => esc_html__('Lorem ipsum dolor sit amet, consectetur ahkl adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud', 'poket'),
            'args' => array(
                'teeny' => true,
                'textarea_rows' => 5,
                'media_buttons' => false,
            )
        ),
        array(
            'id' => 'poket_social_title_text_color',
            'type' => 'color',
            'title' => esc_html__('Footer logo Title Text Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.footer-top-inner h2'
            )
        ),
        array(
            'id' => 'poket_social_title2_text_color',
            'type' => 'color',
            'title' => esc_html__('Footer logo Title Text Color 2', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.footer-top-inner h2 span'
            )
        ),
        array(
            'id' => 'poket_social_text_color',
            'type' => 'color',
            'title' => esc_html__('Footer logo content Text Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.footer-top-inner p'
            )
        ),
        array(
            'id' => 'poket_social_bg_color',
            'type' => 'background',
            'title' => esc_html__('Footer logo Section BG Color', 'poket'),
            'default' => '',
            'output' => array(
                '
						.footer-top
					'
            ),
            'default' => array(
                'background-color' => '',
            )
        ),
        array(
            'id' => 'poket_social_section_spacing',
            'type' => 'spacing',
            'output' => array(
                '.footer-top'
            ),
            'mode' => 'padding',
            'units' => array(
                'em',
                'px'
            ),
            'units_extended' => 'false',
            'title' => esc_html__('Padding Option', 'poket'),
            'subtitle' => esc_html__('Allow your users to choose the spacing padding they want.', 'poket'),
            'desc' => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'poket'),
            'default' => array(
                'padding-top' => '',
                'padding-right' => '',
                'padding-bottom' => '',
                'padding-left' => '',
                'units' => 'px',
            )
        ),

    )
));
/*  footer widget area */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Footer Widget Section', 'poket'),
    'id' => 'poket_widget_section',
    'subsection' => true,
    'icon' => 'el el-circle-arrow-right',
    'fields' => array(
        array(
            'id' => 'colorf_alf_bg_color',
            'type' => 'background',
            'title' => esc_html__('All Footer Background', 'poket'),
            'default' => '',
            'output' => array(
                '.all_footer_bg'
            ),
            'default' => array(
                'background-color' => '',
            )
        ),
        array(
            'id' => 'poket_wmb_bg_color',
            'type' => 'background',
            'title' => esc_html__('Together Widget and Cppyright Section BG Color', 'poket'),
            'default' => '',
            'output' => array(
                '.witrfm_area'
            ),
            'default' => array(
                'background-color' => '',
            )
        ),
        array(
            'id' => 'footer_wcs_gr',
            'type' => 'color_gradient',
            'title' => esc_html__('Widget and Cppyright Section Gradient BG Color', 'poket'),
            'desc' => esc_html__('Set Gradient From here.', 'poket'),
            'validate' => 'color',
            'default' => array(
                'from' => '',
                'to' => '',
            )
        ),
        array(
            'id' => 'poket_wmbov_bg_color',
            'type' => 'color_rgba',
            'title' => esc_html__('Widget and Cppyright Section Overlay', 'poket'),
            'default' => array(
                'color' => '#00509f',
                'alpha' => 0
            ),
            'output' => array(
                'background-color' => '.witrfm_area:before'
            )
        ),
        array(
            'id' => 'twr_heading_widget_c',
            'type' => 'info',
            'desc' => esc_html__('Please set your column Width Below options. total column width - 100%', 'poket')
        ),
        array(
            'id' => 'poket_widget_column_count1',
            'type' => 'select',
            'title' => esc_html__('Footer Widget 1', 'poket'),
            'customizer_only' => false,
            'options' => array(
                '1' => esc_html__('Column 1 =  8.33%', 'poket'),
                '2' => esc_html__('Column 2 = 16.66%', 'poket'),
                '3' => esc_html__('Column 3 = 25%', 'poket'),
                '4' => esc_html__('Column 4 = 33.33%', 'poket'),
                '6' => esc_html__('Column 6 = 50%', 'poket'),
                '12' => esc_html__('Column 12 = 100%', 'poket'),
                'd-none' => esc_html__('Column Hide', 'poket'),
            ),
            'default' => '4'
        ),
        array(
            'id' => 'poket_widget_column_count2',
            'type' => 'select',
            'title' => esc_html__('Footer Widget 2', 'poket'),
            'customizer_only' => false,
            'options' => array(
                '1' => esc_html__('Column 1 =  8.33%', 'poket'),
                '2' => esc_html__('Column 2 = 16.66%', 'poket'),
                '3' => esc_html__('Column 3 = 25%', 'poket'),
                '4' => esc_html__('Column 4 = 33.33%', 'poket'),
                '6' => esc_html__('Column 6 = 50%', 'poket'),
                '12' => esc_html__('Column 12 = 100%', 'poket'),
                'd-none' => esc_html__('Column Hide', 'poket'),
            ),
            'default' => '2'
        ),
        array(
            'id' => 'poket_widget_column_count3',
            'type' => 'select',
            'title' => esc_html__('Footer Widget 3', 'poket'),
            'customizer_only' => false,
            'options' => array(
                '1' => esc_html__('Column 1 =  8.33%', 'poket'),
                '2' => esc_html__('Column 2 = 16.66%', 'poket'),
                '3' => esc_html__('Column 3 = 25%', 'poket'),
                '4' => esc_html__('Column 4 = 33.33%', 'poket'),
                '6' => esc_html__('Column 6 = 50%', 'poket'),
                '12' => esc_html__('Column 12 = 100%', 'poket'),
                'd-none' => esc_html__('Column Hide', 'poket'),
            ),
            'default' => '2'
        ),
        array(
            'id' => 'poket_widget_column_count4',
            'type' => 'select',
            'title' => esc_html__('Footer Widget 4', 'poket'),
            'customizer_only' => false,
            'options' => array(
                '1' => esc_html__('Column 1 =  8.33%', 'poket'),
                '2' => esc_html__('Column 2 = 16.66%', 'poket'),
                '3' => esc_html__('Column 3 = 25%', 'poket'),
                '4' => esc_html__('Column 4 = 33.33%', 'poket'),
                '6' => esc_html__('Column 6 = 50%', 'poket'),
                '12' => esc_html__('Column 12 = 100%', 'poket'),
                'd-none' => esc_html__('Column Hide', 'poket'),
            ),
            'default' => '4'
        ),
        array(
            'id' => 'poket_fwtc',
            'type' => 'color',
            'title' => esc_html__('Widget Title Text Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.footer-middle .widget h2'
            )
        ),
        array(
            'id' => 'poket_fwc',
            'type' => 'color',
            'title' => esc_html__('Widget Text Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '
							.footer-middle .widget ul li,
							.footer-middle .widget ul li a,
							.footer-middle .widget ul li::before,
							.footer-middle .tagcloud a,
							.footer-middle caption,
							.footer-middle table,
							.footer-middle table td a,
							.footer-middle cite,
							.footer-middle .rssSummary,
							.footer-middle span.rss-date,
							.footer-middle span.comment-author-link,
							.footer-middle .textwidget p,
							.footer-middle .widget .screen-reader-text,
							.poket_f_color .widget p,
							.mc4wp-form-fields p,
							.mc4wp-form-fields,
							.footer-m-address p,
							.footer-m-address,
							.footer-widget.address i,
							.footer-widget.address p,
							.mc4wp-form-fields p,
							.poket-description-area p, 
							.poket-description-area .phone a,
							.recent-review-content h3,
							.recent-review-content h3 a,
							.recent-review-content p,
							.footer-middle .poket-description-area p,
							.footer-middle .recent-post-text h4 a,
							.footer-middle .recent-post-text .rcomment,
							.witr_sub_table span
							
						'
            )
        ),
        array(
            'id' => 'poket_fwch',
            'type' => 'color',
            'title' => esc_html__('Widget Text Hover Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '
							.footer-middle .widget ul li a:hover,
							.footer-middle .widget ul li:hover::before,
							.footer-middle .sub-menu li a:hover, 
							.footer-middle .nav .children li a:hover,
							.footer-middle .tagcloud a:hover,
							#today
						'
            )
        ),
        array(
            'id' => 'poket_fwbg',
            'type' => 'background',
            'title' => esc_html__('Widget Section BG Color', 'poket'),
            'default' => '',
            'output' => array(
                '
				.footer-middle
				'
            ),
            'default' => array(
                'background-color' => '',
            )
        ),
        array(
            'id' => 'poket_fwpd',
            'type' => 'spacing',
            'output' => array(
                '.footer-middle'
            ),
            'mode' => 'padding',
            'units' => array(
                'em',
                'px'
            ),
            'units_extended' => 'false',
            'title' => esc_html__('Padding Option', 'poket'),
            'subtitle' => esc_html__('Allow your users to choose the spacing padding they want.', 'poket'),
            'desc' => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'poket'),
            'default' => array(
                'padding-top' => '',
                'padding-right' => '',
                'padding-bottom' => '',
                'padding-left' => '',
                'units' => 'px',
            )
        ),

    )
));

/* footer copyright text */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Footer Copyright Info', 'poket'),
    'id' => 'poket_copyright',
    'desc' => esc_html__('Insert your copyright style', 'poket'),
    'icon' => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields' => array(
        array(
            'id' => 'poket_fcst',
            'type' => 'select',
            'title' => esc_html__('Copyright Style Layout', 'poket'),
            'customizer_only' => false,
            'options' => array(
                'copy_s1' => esc_html__('Copyright Text Style', 'poket'),
                'copy_s2' => esc_html__('Copyright Text and Right Menu', 'poket'),
                'copy_s3' => esc_html__('Copyright Text and Left Menu', 'poket'),
                'copy_s4' => esc_html__('Copyright Text and Social Icon', 'poket'),
            ),
            'default' => 'copy_s2'
        ),
        array(
            'id' => 'poket_wftp_color',
            'type' => 'background',
            'title' => esc_html__('Top Boeder Color', 'poket'),
            'default' => '',
            'output' => array(
                '
						.footer-bottom:before
					'
            ),
            'default' => array(
                'background-color' => '',
            )
        ),

        array(
            'id' => 'poket_copyright_text',
            'type' => 'editor',
            'title' => esc_html__('Copyright information', 'poket'),
            'subtitle' => esc_html__('HTML tags allowed: a, br, em, strong', 'poket'),
            'default' => esc_html__('Copyright &copy; poket all rights reserved.', 'poket'),
            'args' => array(
                'teeny' => true,
                'textarea_rows' => 5,
                'media_buttons' => false,
            )
        ),
        array(
            'id' => 'poket_fcc',
            'type' => 'color',
            'title' => esc_html__('Copyright Text Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.copy-right-text p,.footer-menu ul li a'
            )
        ),
        array(
            'id' => 'poket_fcch',
            'type' => 'color',
            'title' => esc_html__('Copyright Text Hover Color', 'poket'),
            'default' => '',
            'output' => array(
                'color' => '.copy-right-text a, .footer-menu ul li a:hover'
            )
        ),
        array(
            'id' => 'poket_fcbg',
            'type' => 'background',
            'title' => esc_html__('Copyright Section BG Color', 'poket'),
            'default' => '',
            'output' => array(
                '
				.footer-bottom
				'
            ),
            'default' => array(
                'background-color' => '',
            )
        ),

        array(
            'id' => 'poket_fcr_pd',
            'type' => 'spacing',
            'output' => array(
                '.footer-bottom'
            ),
            'mode' => 'padding',
            'units' => array(
                'em',
                'px'
            ),
            'units_extended' => 'false',
            'title' => esc_html__('Padding Option', 'poket'),
            'subtitle' => esc_html__('Allow your users to choose the spacing padding they want.', 'poket'),
            'desc' => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'poket'),
            'default' => array(
                'padding-top' => '',
                'padding-right' => '',
                'padding-bottom' => '',
                'padding-left' => '',
                'units' => 'px',
            )
        ),

    ),
));

/* ========================
END poket FOOTER FIELD
=========================*/
